/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextWrapper;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxOutput;
import org.richfaces.context.AjaxOutputTracker;
import org.richfaces.context.BaseExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.context.MetaComponentEncodingVisitCallback;

public class ExtendedRenderVisitContext
extends BaseExtendedVisitContext {
    private boolean limitRender;

    public ExtendedRenderVisitContext(VisitContext visitContextToWrap, FacesContext facesContext, Collection<String> clientIds, Set<VisitHint> hints, boolean limitRender) {
        super(visitContextToWrap, facesContext, clientIds, hints, ExtendedVisitContextMode.RENDER);
        this.limitRender = limitRender;
    }

    @Override
    public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callbackToWrap) {
        MetaComponentEncodingVisitCallback callback = new MetaComponentEncodingVisitCallback(callbackToWrap, this.getFacesContext());
        return super.invokeVisitCallback(component, callback);
    }

    @Override
    protected boolean hasImplicitSubtreeIdsToVisit(UIComponent component) {
        return !this.limitRender && AjaxOutputTracker.hasNestedAjaxOutputs(component);
    }

    @Override
    protected void addDirectSubtreeIdsToVisitForImplicitComponents(UIComponent component, Set<String> result) {
        Collection<String> directChildrenIds;
        if (!this.limitRender && (directChildrenIds = AjaxOutputTracker.getDirectChildrenIds(component)) != null && !directChildrenIds.isEmpty()) {
            result.addAll(directChildrenIds);
        }
    }

    @Override
    protected VisitResult invokeVisitCallbackForImplicitComponent(UIComponent component, VisitCallback callback) {
        AjaxOutput ajaxOutput;
        if (!this.limitRender && component instanceof AjaxOutput && (ajaxOutput = (AjaxOutput)((Object)component)).isAjaxRendered()) {
            return callback.visit(this, component);
        }
        return VisitResult.ACCEPT;
    }

    @Override
    protected boolean shouldCompleteOnEmptyIds() {
        return this.limitRender;
    }

    public static boolean isExtendedRenderVisitContext(VisitContext visitContext) {
        if (visitContext instanceof ExtendedRenderVisitContext) {
            return true;
        }
        VisitContext wrapped = visitContext;
        while (wrapped instanceof VisitContextWrapper) {
            if (!((wrapped = ((VisitContextWrapper)wrapped).getWrapped()) instanceof ExtendedRenderVisitContext)) continue;
            return true;
        }
        return false;
    }
}

