/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.context.IdSplitIterator;
import org.richfaces.context.NamingContainerVisitContext;
import org.richfaces.util.SeparatorChar;

public class BaseExtendedVisitContext
extends ExtendedVisitContext {
    private Collection<String> clientIds;
    private Collection<String> shortIds;
    private SetMultimap<String, String> subtreeIds;
    private ListMultimap<String, String> directSubtreeIds;
    private CollectionProxy proxiedClientIds;
    protected final ClientIdTrackingStrategy addNode = new ClientIdTrackingStrategy(){

        @Override
        public void visitSubtreeId(String baseId, String clientId) {
            BaseExtendedVisitContext.this.subtreeIds.put(baseId, clientId);
        }

        @Override
        public void visitDirectSubtreeId(String baseId, String shortId) {
            BaseExtendedVisitContext.this.directSubtreeIds.put(baseId, shortId);
        }

        @Override
        public void visitShortId(String shortId) {
            BaseExtendedVisitContext.this.shortIds.add(shortId);
        }
    };
    protected final ClientIdTrackingStrategy removeNode = new ClientIdTrackingStrategy(){

        @Override
        public void visitSubtreeId(String baseId, String clientId) {
            BaseExtendedVisitContext.this.subtreeIds.remove(baseId, clientId);
        }

        @Override
        public void visitShortId(String shortId) {
        }

        @Override
        public void visitDirectSubtreeId(String baseId, String shortId) {
            BaseExtendedVisitContext.this.directSubtreeIds.remove(baseId, shortId);
        }
    };

    public BaseExtendedVisitContext(VisitContext visitContextToWrap, FacesContext facesContext, Collection<String> clientIds, Set<VisitHint> hints, ExtendedVisitContextMode contextMode) {
        super(visitContextToWrap, facesContext, contextMode);
        this.initializeCollections(clientIds);
    }

    private void initializeCollections(Collection<String> clientIds) {
        this.subtreeIds = HashMultimap.create();
        this.directSubtreeIds = ArrayListMultimap.create();
        this.shortIds = new HashSet<String>();
        this.clientIds = Sets.newHashSet();
        this.proxiedClientIds = new CollectionProxy();
        this.proxiedClientIds.addAll(clientIds);
    }

    @Override
    public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
        String clientId;
        if (this.shortIds.contains(this.buildExtendedComponentId(component)) && this.clientIds.contains(clientId = this.buildExtendedClientId(component))) {
            VisitResult visitResult = callback.visit(this, component);
            this.removeNode(clientId, true);
            if (this.clientIds.isEmpty() && this.shouldCompleteOnEmptyIds()) {
                return VisitResult.COMPLETE;
            }
            return visitResult;
        }
        return this.invokeVisitCallbackForImplicitComponent(component, callback);
    }

    protected VisitResult invokeVisitCallbackForImplicitComponent(UIComponent component, VisitCallback callback) {
        return VisitResult.ACCEPT;
    }

    private boolean addNode(String clientId) {
        if (this.clientIds.add(clientId)) {
            this.visitClientId(clientId, this.addNode);
            return true;
        }
        return false;
    }

    private void removeNode(String clientId, boolean removeFromClientIds) {
        if (!removeFromClientIds || this.clientIds.remove(clientId)) {
            this.visitClientId(clientId, this.removeNode);
        }
    }

    protected void visitClientId(String clientId, ClientIdTrackingStrategy tracker) {
        IdSplitIterator splitIterator = new IdSplitIterator(clientId);
        boolean isFirstIteration = true;
        while (splitIterator.hasNext()) {
            String shortId = (String)splitIterator.next();
            String subtreeId = splitIterator.getSubtreeId();
            int metaSepIdx = shortId.indexOf(64);
            if (subtreeId != null) {
                tracker.visitSubtreeId(subtreeId, clientId);
                tracker.visitDirectSubtreeId(subtreeId, shortId);
            }
            if (metaSepIdx >= 0) {
                String componentId = shortId.substring(0, metaSepIdx);
                String extraBaseId = SeparatorChar.JOINER.join(subtreeId, componentId);
                tracker.visitDirectSubtreeId(extraBaseId, shortId);
                tracker.visitSubtreeId(extraBaseId, clientId);
            }
            if (!isFirstIteration) continue;
            isFirstIteration = false;
            tracker.visitShortId(shortId);
        }
    }

    @Override
    public Collection<String> getIdsToVisit() {
        return this.proxiedClientIds;
    }

    protected boolean hasImplicitSubtreeIdsToVisit(UIComponent component) {
        return false;
    }

    @Override
    public Collection<String> getSubtreeIdsToVisit(UIComponent component) {
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
        }
        if (this.hasImplicitSubtreeIdsToVisit(component)) {
            return VisitContext.ALL_IDS;
        }
        String clientId = this.buildExtendedClientId(component);
        Set<String> ids = this.subtreeIds.get(clientId);
        Collection<Object> result = !ids.isEmpty() ? Collections.unmodifiableCollection(ids) : Collections.emptySet();
        return result;
    }

    @Override
    public Collection<String> getDirectSubtreeIdsToVisit(UIComponent component) {
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
        }
        String clientId = component.getClientId(this.getFacesContext());
        HashSet<String> result = new HashSet<String>(this.directSubtreeIds.get(clientId));
        this.addDirectSubtreeIdsToVisitForImplicitComponents(component, result);
        if (result != null && !result.isEmpty()) {
            return Collections.unmodifiableCollection(result);
        }
        return Collections.emptySet();
    }

    protected void addDirectSubtreeIdsToVisitForImplicitComponents(UIComponent component, Set<String> result) {
    }

    protected boolean shouldCompleteOnEmptyIds() {
        return true;
    }

    @Override
    public VisitContext createNamingContainerVisitContext(UIComponent component, Collection<String> directIds) {
        return new NamingContainerVisitContext(this, this.getFacesContext(), this.getVisitMode(), component, directIds);
    }

    protected static interface ClientIdTrackingStrategy {
        public void visitSubtreeId(String var1, String var2);

        public void visitDirectSubtreeId(String var1, String var2);

        public void visitShortId(String var1);
    }

    private final class IteratorProxy
    implements Iterator<String> {
        private Iterator<String> wrapped;
        private String current = null;

        private IteratorProxy(Iterator<String> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public String next() {
            this.current = this.wrapped.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                BaseExtendedVisitContext.this.removeNode(this.current, false);
                this.current = null;
            }
            this.wrapped.remove();
        }
    }

    private final class CollectionProxy
    extends AbstractCollection<String> {
        private CollectionProxy() {
        }

        @Override
        public boolean isEmpty() {
            return BaseExtendedVisitContext.this.clientIds.isEmpty();
        }

        @Override
        public int size() {
            return BaseExtendedVisitContext.this.clientIds.size();
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorProxy(BaseExtendedVisitContext.this.clientIds.iterator());
        }

        @Override
        public boolean add(String o) {
            return BaseExtendedVisitContext.this.addNode(o);
        }
    }
}

