/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.util;

import com.google.common.base.Strings;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.richfaces.renderkit.util.RendererUtils;

public final class InputUtils {
    private static final ConverterLookupStrategy DEFAULT_CONVERTER_LOOKUP_STRATEGY = new ConverterLookupStrategy(){

        @Override
        public Converter getConverterByValue(FacesContext context, UIComponent component, Object value) {
            Converter result = null;
            if (component instanceof ValueHolder) {
                result = ((ValueHolder)((Object)component)).getConverter();
            }
            if (result == null && value != null) {
                result = InputUtils.getConverterForType(context, value.getClass());
            }
            return result;
        }

        @Override
        public Converter getConverterByProperty(FacesContext context, UIComponent component) {
            return InputUtils.findConverter(context, component, "value");
        }
    };

    private InputUtils() {
    }

    public static boolean isDisabled(UIComponent component) {
        return RendererUtils.getInstance().isBooleanAttribute(component, "disabled");
    }

    public static boolean isReadOnly(UIComponent component) {
        return RendererUtils.getInstance().isBooleanAttribute(component, "readonly");
    }

    public static Converter getConverterForType(FacesContext context, Class<?> type) {
        if (type == null || Object.class.equals(type)) {
            return null;
        }
        return context.getApplication().createConverter(type);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return InputUtils.getConvertedStringValue(context, component, DEFAULT_CONVERTER_LOOKUP_STRATEGY, value);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, ConverterLookupStrategy converterLookupStrategy, Object value) throws ConverterException {
        Converter converter = converterLookupStrategy.getConverterByValue(context, component, value);
        if (converter != null) {
            return converter.getAsString(context, component, value);
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static Converter findConverter(FacesContext facesContext, UIComponent component, String property) {
        Class<?> valueType;
        ValueExpression ve;
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)((Object)component)).getConverter();
        }
        if (converter == null && (ve = component.getValueExpression(property)) != null && (valueType = ve.getType(facesContext.getELContext())) != null && !Object.class.equals(valueType)) {
            converter = facesContext.getApplication().createConverter(valueType);
        }
        return converter;
    }

    public static Object getConvertedValue(FacesContext context, UIComponent component, Object val) throws ConverterException {
        return InputUtils.getConvertedValue(context, component, DEFAULT_CONVERTER_LOOKUP_STRATEGY, val);
    }

    public static Object getConvertedValue(FacesContext context, UIComponent component, ConverterLookupStrategy converterLookupStrategy, Object val) throws ConverterException {
        String submittedString = (String)val;
        if (Strings.isNullOrEmpty(submittedString)) {
            return null;
        }
        Converter converter = converterLookupStrategy.getConverterByProperty(context, (UIInput)component);
        if (converter != null) {
            return converter.getAsObject(context, component, submittedString);
        }
        return submittedString;
    }

    public static String getInputValue(FacesContext context, UIComponent component) throws ConverterException {
        return InputUtils.getInputValue(context, component, DEFAULT_CONVERTER_LOOKUP_STRATEGY);
    }

    public static String getInputValue(FacesContext context, UIComponent component, ConverterLookupStrategy converterLookupStrategy) throws ConverterException {
        UIInput input = (UIInput)component;
        String submittedValue = (String)input.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue;
        }
        Object value = input.getValue();
        Converter converter = converterLookupStrategy.getConverterByValue(context, input, value);
        if (converter != null) {
            return converter.getAsString(context, input, value);
        }
        return value != null ? value.toString() : "";
    }

    public static interface ConverterLookupStrategy {
        public Converter getConverterByProperty(FacesContext var1, UIComponent var2);

        public Converter getConverterByValue(FacesContext var1, UIComponent var2, Object var3);
    }
}

