/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public final class QueueRegistry {
    public static final String QUEUE_SCRIPT_ID = "_org_richfaces_queue";
    private static final Logger LOGGER = RichfacesLogger.COMPONENTS.getLogger();
    private static final String REGISTRY_ATTRIBUTE_NAME = QueueRegistry.class.getName();
    private Map<String, UIComponent> queuesData = new LinkedHashMap<String, UIComponent>();

    private QueueRegistry() {
    }

    public static QueueRegistry getInstance(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map<String, Object> requestMap = externalContext.getRequestMap();
        QueueRegistry registry = (QueueRegistry)requestMap.get(REGISTRY_ATTRIBUTE_NAME);
        if (registry == null) {
            registry = new QueueRegistry();
            requestMap.put(REGISTRY_ATTRIBUTE_NAME, registry);
        }
        return registry;
    }

    public void addQueue(String clientName, UIComponent component) {
        if (!this.containsQueue(clientName)) {
            this.queuesData.put(clientName, component);
        } else {
            LOGGER.warn("Queue with name '" + clientName + "' has already been registered");
        }
    }

    public UIComponent removeQueue(String clientName) {
        return this.queuesData.remove(clientName);
    }

    public boolean containsQueue(String name) {
        return this.queuesData.containsKey(name);
    }

    public Map<String, UIComponent> getRegisteredQueues() {
        return this.queuesData;
    }

    public boolean hasQueuesToEncode() {
        if (this.queuesData.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, UIComponent> queue : this.queuesData.entrySet()) {
            if (!queue.getValue().isRendered()) continue;
            return true;
        }
        return false;
    }
}

