/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.Iterator;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.json.JSONObject;
import org.richfaces.json.JSONStringer;
import org.richfaces.json.JSONWriter;

class ColumnsVisibility
implements Serializable {
    private static final long serialVersionUID = -3923409650272094713L;
    private static final String TRUE = "1";
    private static final String FALSE = "0";
    private JSONObject value;

    private ColumnsVisibility() {
    }

    static ColumnsVisibility getColumnsVisibility(UIExtendedDataTable extendedDataTable, String val) throws JSONException {
        ColumnsVisibility columnsVisibility = new ColumnsVisibility();
        columnsVisibility.init(extendedDataTable, new JSONMap(val));
        return columnsVisibility;
    }

    static ColumnsVisibility getColumnsVisibility(UIExtendedDataTable extendedDataTable, JSONMap state) {
        ColumnsVisibility columnsVisibility = new ColumnsVisibility();
        columnsVisibility.init(extendedDataTable, state);
        return columnsVisibility;
    }

    private void init(UIExtendedDataTable extendedDataTable, JSONMap state) {
        this.value = null;
        if (state != null && state.size() > 0) {
            this.value = new JSONObject(state);
        }
        if (this.value == null) {
            this.createDefaultColumnsVisibility(extendedDataTable);
        }
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public JSONMap toJSON() {
        return new JSONMap(this.value);
    }

    private void createDefaultColumnsVisibility(UIExtendedDataTable extendedDataTable) {
        try {
            JSONWriter writer = new JSONStringer().object();
            Iterator iter = extendedDataTable.getChildColumns();
            while (iter.hasNext()) {
                UIColumn col = (UIColumn)iter.next();
                writer.key(col.getId()).value(col.isVisible() ? TRUE : FALSE);
            }
            this.value = new JSONObject(writer.endObject().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    boolean isVisible(String columnId) {
        if (this.value == null) {
            return true;
        }
        return !FALSE.equals(this.value.opt(columnId));
    }

    void toggleVisibility(UIExtendedDataTable extendedDataTable, String columnId) {
        if (this.value == null) {
            return;
        }
        UIColumn column = null;
        Iterator iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn col = (UIColumn)iter.next();
            if (!col.getId().equalsIgnoreCase(columnId)) continue;
            column = col;
            break;
        }
        if (column == null) {
            return;
        }
        boolean visible = column.isVisible();
        visible = !visible;
        try {
            this.value.put(columnId, visible ? TRUE : FALSE);
            column.setVisible(visible);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

