/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.cache.Cache;
import org.richfaces.cache.CacheFactory;
import org.richfaces.cache.JBossCacheCache;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class JBossCacheCacheFactory
implements CacheFactory {
    private static final Logger LOG = RichfacesLogger.CACHE.getLogger();
    private org.jboss.cache.CacheFactory<String, Object> cacheFactory = new DefaultCacheFactory();

    private void setupMaxSizeEviction(FacesContext facesContext, org.jboss.cache.Cache<String, Object> cache) {
        EvictionAlgorithmConfigBase baseEvicitonConfig;
        EvictionConfig evictionConfig = cache.getConfiguration().getEvictionConfig();
        EvictionAlgorithmConfig evictionAlgorithmConfig = evictionConfig.getDefaultEvictionRegionConfig().getEvictionAlgorithmConfig();
        if (evictionAlgorithmConfig instanceof EvictionAlgorithmConfigBase && (baseEvicitonConfig = (EvictionAlgorithmConfigBase)evictionAlgorithmConfig).getMaxNodes() <= 0) {
            int maxCacheSize = ConfigurationServiceHelper.getIntConfigurationValue(facesContext, CoreConfiguration.Items.resourcesCacheSize);
            LOG.info(MessageFormat.format("Maximum cache size hasn''t been set, resetting to {0} max items", maxCacheSize));
            baseEvicitonConfig.setMaxNodes(maxCacheSize);
        }
    }

    @Override
    public Cache createCache(FacesContext facesContext, String cacheName, Map<?, ?> env) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        org.jboss.cache.Cache cache = null;
        URL cacheConfigurationURL = null;
        if (contextClassLoader != null) {
            cacheConfigurationURL = contextClassLoader.getResource("jboss-cache.xml");
        }
        if (cacheConfigurationURL != null) {
            InputStream stream = null;
            try {
                stream = URLToStreamHelper.urlToStream(cacheConfigurationURL);
                cache = this.cacheFactory.createCache(stream);
                this.setupMaxSizeEviction(facesContext, (org.jboss.cache.Cache<String, Object>)cache);
            }
            catch (IOException e) {
                throw new FacesException(e.getLocalizedMessage(), e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        LOG.debug(e.getMessage(), e);
                    }
                }
            }
        }
        Configuration configuration = new Configuration();
        EvictionRegionConfig evictionRegionConfig = new EvictionRegionConfig(Fqn.root());
        ExpirationAlgorithmConfig expirationAlgorithm = new ExpirationAlgorithmConfig();
        int maxCacheSize = ConfigurationServiceHelper.getIntConfigurationValue(facesContext, CoreConfiguration.Items.resourcesCacheSize);
        expirationAlgorithm.setMaxNodes(maxCacheSize);
        evictionRegionConfig.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)expirationAlgorithm);
        EvictionConfig evictionConfig = new EvictionConfig(evictionRegionConfig);
        evictionConfig.setWakeupInterval(1000L);
        configuration.setEvictionConfig(evictionConfig);
        cache = this.cacheFactory.createCache(configuration);
        return new JBossCacheCache((org.jboss.cache.Cache<String, Object>)cache);
    }

    @Override
    public void destroy() {
        this.cacheFactory = null;
    }
}

