/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp.nekko;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ajax4jsf.webapp.HtmlParser;
import org.ajax4jsf.webapp.nekko.HtmlCorrectionFilter;
import org.ajax4jsf.xml.serializer.OutputPropertiesFactory;
import org.ajax4jsf.xml.serializer.Serializer;
import org.ajax4jsf.xml.serializer.SerializerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLAugmentations;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.ElementRemover;
import org.cyberneko.html.filters.Purifier;
import org.cyberneko.html.filters.Writer;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NekkoParser
implements HtmlParser {
    private static final Log _log = LogFactory.getLog(NekkoParser.class);
    private HtmlSAXParser _parser;
    private ElementRemover remover = new ElementRemover();
    private XMLDocumentFilter[] _filters = new XMLDocumentFilter[]{new ViewStateFilter(), new HtmlCorrectionFilter(), new Purifier()};
    private DOMFragmentParser viewStateParser;
    private Document viewStateDocument;
    private DocumentFragment fragment = null;
    private Node[] headEvents;
    private String _viewState;
    private String _encoding;
    private Serializer _serializer;
    private String _publicId = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private String _systemid = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private String _namespace = "http://www.w3.org/1999/xhtml";
    private String _outputEncoding;
    private Serializer _XHTMLserializer;
    private Serializer _XMLserialiser;
    private Serializer _HTMLserialiser;

    public void init() {
        this._parser = new HtmlSAXParser(this.getHtmlConfig());
        Properties properties = OutputPropertiesFactory.getDefaultMethodProperties("xhtml");
        this._XHTMLserializer = SerializerFactory.getSerializer(properties);
        properties = OutputPropertiesFactory.getDefaultMethodProperties("xml");
        this._XMLserialiser = SerializerFactory.getSerializer(properties);
        properties = OutputPropertiesFactory.getDefaultMethodProperties("html");
        this._serializer = this._HTMLserialiser = SerializerFactory.getSerializer(properties);
        this.viewStateParser = new DOMFragmentParser();
        try {
            this.viewStateParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            this.viewStateParser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
        }
        catch (SAXException e) {
            _log.error("Exception in DOM parser configuration", e);
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.viewStateDocument = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.viewStateDocument = new HTMLDocumentImpl();
            _log.error("Error on create DOM Document by JAXP, use Xerxes implementation. Check JAXP configuration ", e);
        }
        this.remover.removeElement("style");
    }

    public void reset() {
        this.headEvents = null;
        this._viewState = null;
        this._parser.reset();
        this._XMLserialiser.reset();
        this._HTMLserialiser.reset();
        this._XHTMLserializer.reset();
        this._serializer = this._HTMLserialiser;
    }

    public void parseHtml(InputStream input, java.io.Writer output) throws IOException {
        InputSource src = new InputSource(input);
        this.parseSAXSource(src, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSAXSource(InputSource src, java.io.Writer output) throws IOException {
        this.fragment = null;
        if (null != this._viewState) {
            this.fragment = this.viewStateDocument.createDocumentFragment();
            try {
                this.viewStateParser.parse(new InputSource(new StringReader(this._viewState)), this.fragment);
            }
            catch (Exception e) {
                this.fragment = null;
            }
        }
        try {
            if (null != this._encoding) {
                this._parser.setProperty("http://cyberneko.org/html/properties/default-encoding", this._encoding);
            }
            Properties properties = this._serializer.getOutputFormat();
            if (null != this._outputEncoding) {
                properties.put("encoding", this._outputEncoding);
            }
            this._serializer.setOutputFormat(properties);
            this._serializer.setWriter(output);
            this._parser.setContentHandler(this._serializer.asContentHandler());
            this._parser.parse(src);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void parseHtml(Reader input, java.io.Writer output) throws IOException {
        InputSource src = new InputSource(input);
        this.parseSAXSource(src, output);
    }

    public void setInputEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setOutputEncoding(String encoding) {
        this._outputEncoding = encoding;
    }

    public void setMoveElements(boolean move) {
    }

    public void setDoctype(String doctype) {
        this._publicId = doctype;
    }

    public void setViewState(String viewState) {
        this._viewState = viewState;
    }

    protected HTMLConfiguration getHtmlConfig() {
        HTMLConfiguration _config = new HTMLConfiguration();
        try {
            if (this.getPublicid() != null || this.getSystemid() != null) {
                _config.setFeature("http://cyberneko.org/html/features/insert-doctype", true);
                _config.setFeature("http://cyberneko.org/html/features/override-doctype", true);
            }
            if (this.getPublicid() != null) {
                _config.setProperty("http://cyberneko.org/html/properties/doctype/pubid", (Object)this.getPublicid());
            }
            if (this.getSystemid() != null) {
                _config.setProperty("http://cyberneko.org/html/properties/doctype/sysid", (Object)this.getSystemid());
            }
            if (this.getNamespace() != null) {
                _config.setFeature("http://xml.org/sax/features/namespaces", true);
                _config.setFeature("http://cyberneko.org/html/features/override-namespaces", true);
                _config.setFeature("http://cyberneko.org/html/features/insert-namespaces", true);
                _config.setProperty("http://cyberneko.org/html/properties/namespaces-uri", (Object)this.getNamespace());
            }
            _config.setFeature("http://cyberneko.org/html/features/scanner/cdata-sections", true);
            _config.setFeature("http://cyberneko.org/html/features/scanner/script/strip-comment-delims", true);
            _config.setFeature("http://cyberneko.org/html/features/scanner/style/strip-comment-delims", true);
            _config.setFeature("http://cyberneko.org/html/features/insert-doctype", true);
            _config.setFeature("http://cyberneko.org/html/features/insert-namespaces", true);
            _config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            _config.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
            _config.setProperty("http://cyberneko.org/html/properties/filters", (Object)this._filters);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return _config;
    }

    private String getNamespace() {
        return this._namespace;
    }

    private String getSystemid() {
        return this._systemid;
    }

    private String getPublicid() {
        return this._publicId;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public void setPublicId(String publicId) {
        this._publicId = publicId;
    }

    public void setSystemid(String systemid) {
        this._systemid = systemid;
    }

    public boolean setMime(String mimeType) {
        if (null != mimeType) {
            if (mimeType.startsWith("text/html")) {
                this._serializer = this._HTMLserialiser;
            } else if (mimeType.startsWith("application/xhtml+xml")) {
                this._serializer = this._XHTMLserializer;
            } else if (mimeType.startsWith("text/xml")) {
                this._serializer = this._XHTMLserializer;
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public void setHeadNodes(Node[] headEvents) {
        this.headEvents = headEvents;
    }

    private static class HtmlWriter
    extends Writer {
        public HtmlWriter() {
            this.fEncoding = "UTF-8";
        }

        public void setEncoding(String encoding) {
            this.fEncoding = encoding;
        }

        public void setWriter(PrintWriter writer) {
            this.fPrinter = writer;
        }

        public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            super.emptyElement(element, attributes, augs);
            this.printEndElement(element);
        }

        public void endCDATA(Augmentations augs) throws XNIException {
            super.endCDATA(augs);
        }

        public void startCDATA(Augmentations augs) throws XNIException {
            super.startCDATA(augs);
        }

        public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
            super.textDecl(version, encoding, augs);
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            super.xmlDecl(version, encoding, standalone, augs);
        }
    }

    private class ViewStateFilter
    extends DefaultFilter {
        private boolean haveHtml = false;
        private boolean haveHead = false;
        private boolean headParsed = false;
        private int stateMarkerLevel = -1;

        private ViewStateFilter() {
        }

        public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
            this.haveHead = false;
            this.haveHtml = false;
            this.headParsed = false;
            this.stateMarkerLevel = -1;
            super.reset(componentManager);
        }

        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            if (this.stateMarkerLevel >= 0) {
                ++this.stateMarkerLevel;
                if (null != NekkoParser.this.fragment) {
                    return;
                }
            }
            if (!this.headParsed) {
                if ("html".equalsIgnoreCase(element.rawname)) {
                    this.haveHtml = true;
                } else {
                    if ("head".equalsIgnoreCase(element.rawname)) {
                        this.haveHead = true;
                        super.startElement(element, attributes, augs);
                        return;
                    }
                    if (this.haveHead) {
                        if (!("title".equalsIgnoreCase(element.rawname) || "base".equalsIgnoreCase(element.rawname) || "meta".equalsIgnoreCase(element.rawname))) {
                            this.insertResources(element.prefix, element.uri);
                        }
                    } else {
                        if (!this.haveHtml) {
                            this.insertStartElement("html");
                        }
                        this.insertStartElement("head");
                        this.insertResources(element.prefix, element.uri);
                        this.insertEndElement("head");
                    }
                }
            }
            if (this.stateMarkerLevel < 0 && this.isStateMarker(element, attributes)) {
                this.stateMarkerLevel = 0;
                return;
            }
            super.startElement(element, attributes, augs);
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (this.stateMarkerLevel >= 0 && null != NekkoParser.this.fragment) {
                return;
            }
            super.characters(text, augs);
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            if (this.stateMarkerLevel >= 0) {
                --this.stateMarkerLevel;
                if (null != NekkoParser.this.fragment || this.stateMarkerLevel == -1) {
                    return;
                }
            }
            if (!this.headParsed && "head".equalsIgnoreCase(element.rawname)) {
                this.insertResources(element.prefix, element.uri);
            }
            super.endElement(element, augs);
        }

        private XMLString createXMLString(String string) {
            char[] cs = string.toCharArray();
            return new XMLString(cs, 0, cs.length);
        }

        private void addNode(Node node, String prefix, String uri, Augmentations augs) {
            switch (node.getNodeType()) {
                case 3: {
                    String charData = ((CharacterData)node).getData();
                    super.characters(this.createXMLString(charData), augs);
                    break;
                }
                case 8: {
                    String charData = ((CharacterData)node).getData();
                    super.comment(this.createXMLString(charData), augs);
                    break;
                }
                case 4: {
                    String charData = ((CharacterData)node).getData();
                    super.startCDATA(augs);
                    super.characters(this.createXMLString(charData), augs);
                    super.endCDATA(augs);
                    break;
                }
                case 1: {
                    QName name = new QName(prefix, node.getNodeName(), node.getNodeName(), uri);
                    XMLAttributesImpl attrs = new XMLAttributesImpl();
                    NamedNodeMap attributes = node.getAttributes();
                    if (attributes != null) {
                        int l = attributes.getLength();
                        for (int i = 0; i < l; ++i) {
                            Node attributeNode = attributes.item(i);
                            attrs.addAttribute(new QName(prefix, attributeNode.getNodeName(), attributeNode.getNodeName(), uri), "CDATA", attributeNode.getNodeValue());
                        }
                    }
                    super.startElement(name, (XMLAttributes)attrs, augs);
                    NodeList childNodes = node.getChildNodes();
                    int nodesLength = childNodes.getLength();
                    for (int i = 0; i < nodesLength; ++i) {
                        this.addNode(childNodes.item(i), prefix, uri, augs);
                    }
                    super.endElement(name, augs);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Node type " + node.getNodeType() + " is not supported!");
                }
            }
        }

        private void insertResources(String prefix, String uri) {
            this.headParsed = true;
            if (NekkoParser.this.headEvents != null && NekkoParser.this.headEvents.length > 0) {
                HTMLAugmentations augs = new HTMLAugmentations();
                for (Node node : NekkoParser.this.headEvents) {
                    this.addNode(node, prefix, uri, (Augmentations)augs);
                }
            }
        }

        public void emptyElement(QName name, XMLAttributes attributes, Augmentations augmentation) throws XNIException {
            if (this.stateMarkerLevel >= 0 && null != NekkoParser.this.fragment) {
                return;
            }
            if (!this.headParsed) {
                if (this.haveHead) {
                    if (!("title".equalsIgnoreCase(name.rawname) || "base".equalsIgnoreCase(name.rawname) || "meta".equalsIgnoreCase(name.rawname))) {
                        this.insertResources(name.prefix, name.uri);
                    }
                } else if ("head".equalsIgnoreCase(name.rawname)) {
                    this.haveHead = true;
                    super.startElement(name, attributes, augmentation);
                    this.insertResources(name.prefix, name.uri);
                    this.insertEndElement(name.rawname);
                    return;
                }
            }
            if (this.isStateMarker(name, attributes)) {
                return;
            }
            super.emptyElement(name, attributes, augmentation);
        }

        private boolean isStateMarker(QName name, XMLAttributes attributes) {
            if (name.rawname.equalsIgnoreCase("span") && "org.ajax4jsf.view.state".equals(attributes.getValue("id"))) {
                if (null != NekkoParser.this.fragment) {
                    try {
                        NekkoParser.this._serializer.asDOMSerializer().serialize(NekkoParser.this.fragment);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return true;
            }
            return false;
        }

        void insertStartElement(String name) {
            QName element = new QName(null, name, name, null);
            XMLAttributesImpl attrs = new XMLAttributesImpl();
            HTMLAugmentations augs = new HTMLAugmentations();
            super.startElement(element, (XMLAttributes)attrs, (Augmentations)augs);
        }

        void insertEndElement(String name) {
            QName element = new QName(null, name, name, null);
            HTMLAugmentations augs = new HTMLAugmentations();
            super.endElement(element, (Augmentations)augs);
        }

        public void endDocument(Augmentations augs) throws XNIException {
            if (!this.haveHtml) {
                this.insertEndElement("html");
            }
            super.endDocument(augs);
        }
    }

    private static class HtmlSAXParser
    extends AbstractSAXParser {
        public HtmlSAXParser(HTMLConfiguration config) {
            super((XMLParserConfiguration)config);
        }
    }
}

