/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InternetResourceBuilder {
    private static final Log log = LogFactory.getLog(InternetResourceBuilder.class);
    public static final String LOAD_NONE = "NONE";
    public static final String LOAD_ALL = "ALL";
    public static final String SKINNING_SCRIPT = "/org/richfaces/renderkit/html/scripts/skinning.js";
    public static final String COMMON_FRAMEWORK_SCRIPT = "/org/ajax4jsf/framework.pack.js";
    public static final String COMMON_UI_SCRIPT = "/org/richfaces/ui.pack.js";
    public static final String COMMON_STYLE_PREFIX = "/org/richfaces/skin";
    public static final String COMMON_STYLE_EXTENSION = ".xcss";
    public static final String COMMON_STYLE = "/org/richfaces/skin.xcss";
    public static final String LOAD_STYLE_STRATEGY_PARAM = "org.richfaces.LoadStyleStrategy";
    public static final String LOAD_SCRIPT_STRATEGY_PARAM = "org.richfaces.LoadScriptStrategy";
    public static final String STD_CONTROLS_SKINNING_PARAM = "org.richfaces.CONTROL_SKINNING";
    public static final String STD_CONTROLS_SKINNING_CLASSES_PARAM = "org.richfaces.CONTROL_SKINNING_CLASSES";
    public static final String ENABLE = "enable";
    public static final String CONTROL_SKINNING_LEVEL = "org.richfaces.CONTROL_SKINNING_LEVEL";
    public static final String BASIC = "basic";
    public static final String EXTENDED = "extended";
    private static Map<ClassLoader, InternetResourceBuilder> instances = Collections.synchronizedMap(new HashMap());

    public abstract long getStartTime();

    public abstract InternetResource createUserResource(boolean var1, boolean var2, String var3) throws FacesException;

    public abstract void addResource(String var1, InternetResource var2);

    public abstract InternetResource getResource(String var1) throws ResourceNotFoundException;

    public abstract Object getResourceDataForKey(String var1);

    public abstract InternetResource getResourceForKey(String var1) throws ResourceNotFoundException;

    public abstract String getUri(InternetResource var1, FacesContext var2, Object var3);

    public abstract InternetResource createResource(Object var1, String var2) throws FacesException;

    public abstract void init() throws FacesException;

    public static InternetResourceBuilder getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InternetResourceBuilder instance = instances.get(loader);
        if (null == instance) {
            block6: {
                try {
                    String serviceClassName = "org.ajax4jsf.resource.ResourceBuilderImpl";
                    String resource = "META-INF/services/" + InternetResourceBuilder.class.getName();
                    InputStream in = URLToStreamHelper.urlToStreamSafe(loader.getResource(resource));
                    if (null != in) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                        serviceClassName = reader.readLine();
                        reader.close();
                        in.close();
                    }
                    Class<?> builderClass = loader.loadClass(serviceClassName);
                    instance = (InternetResourceBuilder)builderClass.newInstance();
                    if (log.isDebugEnabled()) {
                        log.debug("Create instance of InternetBuilder from class " + serviceClassName);
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.error("Can't create instance of InternetBuilder service", e);
                    throw new FacesException("Error on create instance of InternetBuilder service", e);
                }
            }
            instances.put(loader, instance);
        }
        if (log.isDebugEnabled()) {
            log.debug("Return instance of internet resource builder " + instance.toString());
        }
        return instance;
    }

    public static void setInstance(InternetResourceBuilder instance) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        instances.put(loader, instance);
    }

    public abstract ResourceRenderer getStyleRenderer();

    public abstract ResourceRenderer getScriptRenderer();
}

