/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.CachedResourceContext;
import org.ajax4jsf.resource.FacesResourceContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternetResourceBase
implements InternetResource {
    private static final Log log = LogFactory.getLog(InternetResourceBase.class);
    static final int BUFFER_SIZE = 1024;
    private int contentLength = -1;
    private Date lastModified = new Date(System.currentTimeMillis());
    private long expired = Long.MIN_VALUE;
    private boolean cacheable = true;
    private boolean sessionAware = true;
    private ResourceRenderer renderer = null;
    private Map<Object, Object> customProperties = new HashMap<Object, Object>();
    private String key;

    @Override
    public int getContentLength(ResourceContext resourceContext) {
        return this.contentLength;
    }

    protected void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public long getExpired(ResourceContext resourceContext) {
        if (this.expired == Long.MIN_VALUE) {
            this.expired = -1L;
            String defaultExpireParameter = resourceContext.getInitParameter("org.ajax4jsf.DEFAULT_EXPIRE");
            if (null != defaultExpireParameter) {
                this.expired = Long.parseLong(defaultExpireParameter) * 1000L;
            }
        }
        return this.expired;
    }

    @Override
    public void setExpired(long expired) {
        this.expired = expired;
    }

    @Override
    public Date getLastModified(ResourceContext resourceContext) {
        if (null != this.lastModified) {
            return this.lastModified;
        }
        return new Date(System.currentTimeMillis());
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public boolean isCacheable(ResourceContext resourceContext) {
        return this.cacheable;
    }

    @Override
    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public boolean isSessionAware() {
        return this.requireFacesContext();
    }

    @Override
    public void setSessionAware(boolean sessionAware) {
        this.sessionAware = sessionAware;
    }

    @Override
    public String getContentType(ResourceContext resourceContext) {
        return this.getRenderer(resourceContext).getContentType();
    }

    @Override
    public ResourceRenderer getRenderer(ResourceContext resourceContext) {
        return this.renderer;
    }

    @Override
    public void setRenderer(ResourceRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getUri(FacesContext context, Object data) {
        return InternetResourceBuilder.getInstance().getUri(this, context, this.getDataToStore(context, data));
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        return this.getRenderer(new FacesResourceContext(context)).getData(this, context, data);
    }

    protected Object restoreData(ResourceContext context) {
        Object data = context.getResourceData();
        if (data instanceof byte[]) {
            byte[] objectArray = (byte[])data;
            data = this.deserializeData(objectArray);
        }
        return data;
    }

    protected Object deserializeData(byte[] objectArray) {
        return objectArray;
    }

    @Override
    public InputStream getResourceAsStream(ResourceContext context) {
        throw new UnsupportedOperationException(Messages.getMessage("METHOD_NOT_IMPLEMENTED", "getResourceAsStream"));
    }

    @Override
    public Object getProperty(Object key) {
        return this.customProperties.get(key);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.customProperties.put(key, value);
    }

    @Override
    public void encode(FacesContext context, Object data) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("ENCODE_HTML_INFO", this.getKey()));
        }
        this.getRenderer(new FacesResourceContext(context)).encode(this, context, data);
    }

    @Override
    public void encode(FacesContext context, Object data, Map<String, Object> attributes) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("ENCODE_HTML_INFO_2", this.getKey(), attributes));
        }
        this.getRenderer(new FacesResourceContext(context)).encodeBegin(this, context, data, attributes);
        this.getRenderer(new FacesResourceContext(context)).encodeEnd(this, context, data);
    }

    @Override
    public void encodeBegin(FacesContext context, Object component, Map<String, Object> attrs) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("ENCODE_BEGIN_HTML_INFO", this.getKey(), attrs));
        }
        this.getRenderer(new FacesResourceContext(context)).encodeBegin(this, context, component, attrs);
    }

    @Override
    public void encodeEnd(FacesContext context, Object component) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("ENCODE_END_HTML_INFO", this.getKey()));
        }
        this.getRenderer(new FacesResourceContext(context)).encodeEnd(this, context, component);
    }

    @Override
    public void send(ResourceContext context) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("SEND_CONTENT_INFO", this.getKey()));
        }
        int total = this.getRenderer(context).send(this, context);
        if (this.isCacheable(context)) {
            if (context instanceof CachedResourceContext) {
                CachedResourceContext cachedContext = (CachedResourceContext)context;
                cachedContext.getContent().setContentLength(total);
            } else {
                this.setContentLength(total);
            }
        }
    }

    @Override
    public void sendHeaders(ResourceContext context) {
        boolean cached;
        boolean bl = cached = context.isCacheEnabled() && this.isCacheable(context);
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("SET_RESPONSE_HEADERS_INFO", this.getKey()));
        }
        context.setContentType(this.getContentType(context));
        Date lastModified = this.getLastModified(context);
        if (lastModified != null) {
            context.setDateHeader("Last-Modified", lastModified.getTime());
        }
        int contentLength = this.getContentLength(context);
        if (cached) {
            long expired;
            if (contentLength > 0) {
                context.setContentLength(contentLength);
            }
            if ((expired = this.getExpired(context)) < 0L) {
                expired = 86400000L;
            }
            context.setDateHeader("Expires", System.currentTimeMillis() + expired);
            context.setHeader("Cache-control", "max-age=" + expired / 1000L);
        } else {
            if (contentLength > 0) {
                context.setContentLength(contentLength);
            }
            context.setHeader("Cache-control", "max-age=0, no-store, no-cache");
            context.setHeader("Pragma", "no-cache");
            context.setIntHeader("Expires", 0);
        }
    }

    @Override
    public boolean requireFacesContext() {
        return this.getRenderer(null).requireFacesContext();
    }
}

