/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.UIMediaOutput;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;

public class MediaOutputRenderer
extends RendererBase {
    public static final String RENDERER_TYPE = "org.ajax4jsf.MMediaRenderer";
    private static final Map uriAttributes = new HashMap();

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIMediaOutput mmedia = (UIMediaOutput)component;
        String element = mmedia.getElement();
        if (null == element) {
            throw new FacesException(Messages.getMessage("NULL_ATTRIBUTE_ERROR", "element", component.getClientId(context)));
        }
        writer.endElement(element);
    }

    protected Class getComponentClass() {
        return UIMediaOutput.class;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIMediaOutput mmedia = (UIMediaOutput)component;
        String element = mmedia.getElement();
        if (null == element) {
            throw new FacesException(Messages.getMessage("NULL_ATTRIBUTE_ERROR", "element", component.getClientId(context)));
        }
        String uriAttribute = mmedia.getUriAttribute();
        if (null == uriAttribute && null == (uriAttribute = (String)uriAttributes.get(element))) {
            throw new FacesException(Messages.getMessage("NULL_ATTRIBUTE_ERROR", "uriAttribute", component.getClientId(context)));
        }
        writer.startElement(element, mmedia);
        this.getUtils().encodeId(context, component);
        InternetResourceBuilder internetResourceBuilder = InternetResourceBuilder.getInstance();
        InternetResource resource = internetResourceBuilder.createUserResource(mmedia.isCacheable(), mmedia.isSession(), mmedia.getMimeType());
        StringBuffer uri = new StringBuffer(resource.getUri(context, mmedia));
        boolean haveQestion = uri.indexOf("?") >= 0;
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter uiParam = (UIParameter)kid;
            String name = uiParam.getName();
            Object value = uiParam.getValue();
            if (null == value) continue;
            if (haveQestion) {
                uri.append('&');
            } else {
                uri.append('?');
                haveQestion = true;
            }
            uri.append(name).append('=').append(value.toString());
        }
        writer.writeURIAttribute(uriAttribute, uri, "uri");
        this.getUtils().encodeAttributesFromArray(context, component, RendererUtils.HTML.PASS_THRU_STYLES);
        this.getUtils().encodeAttribute(context, component, "type");
        this.getUtils().encodeAttribute(context, component, "classid");
        this.getUtils().encodePassThru(context, mmedia);
    }

    static {
        uriAttributes.put("a", "href");
        uriAttributes.put("img", "src");
        uriAttributes.put("object", "data");
        uriAttributes.put("link", "href");
    }
}

