/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIAjaxOutputPanel;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.renderkit.RendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxOutputPanelRenderer
extends RendererBase {
    private final String[] STYLE_ATTRIBUTES = new String[]{"style", "class"};

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UIAjaxOutputPanel panel = (UIAjaxOutputPanel)component;
        if ("none".equals(panel.getLayout())) {
            if (component.getChildCount() > 0) {
                AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
                boolean ajaxRequest = ajaxContext.isAjaxRequest();
                Set<String> ajaxRenderedAreas = ajaxContext.getAjaxRenderedAreas();
                for (UIComponent child : component.getChildren()) {
                    String childId = child.getClientId(context);
                    if (child.isRendered()) {
                        this.renderChild(context, child);
                    } else {
                        ResponseWriter out = context.getResponseWriter();
                        out.startElement("span", child);
                        out.writeAttribute("id", childId, "id");
                        out.writeAttribute("style", "display: none;", "style");
                        out.endElement("span");
                    }
                    if (!ajaxRequest || null == ajaxRenderedAreas) continue;
                    ajaxRenderedAreas.add(childId);
                }
            }
        } else {
            this.renderChildren(context, component);
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIAjaxOutputPanel.class;
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIAjaxOutputPanel panel = (UIAjaxOutputPanel)component;
        if (!"none".equals(panel.getLayout())) {
            writer.startElement(this.getTag(panel), panel);
            this.getUtils().encodeId(context, component);
            this.getUtils().encodePassThru(context, component);
            this.getUtils().encodeAttributesFromArray(context, component, this.STYLE_ATTRIBUTES);
        }
    }

    private String getTag(UIAjaxOutputPanel panel) {
        return "block".equals(panel.getLayout()) ? "div" : "span";
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIAjaxOutputPanel panel = (UIAjaxOutputPanel)component;
        if (!"none".equals(panel.getLayout())) {
            writer.endElement(this.getTag(panel));
        }
        if (panel.isKeepTransient()) {
            this.markNoTransient(component);
        }
    }

    private void markNoTransient(UIComponent component) {
        Iterator<UIComponent> iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent element = iter.next();
            this.markNoTransient(element);
            element.setTransient(false);
        }
    }
}

