/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.compiler.ElementBase;
import org.ajax4jsf.renderkit.compiler.InvokeData;
import org.ajax4jsf.renderkit.compiler.Invoker;
import org.ajax4jsf.renderkit.compiler.MethodCacheState;
import org.ajax4jsf.renderkit.compiler.MethodParameterElement;
import org.ajax4jsf.renderkit.compiler.PreparedTemplate;
import org.ajax4jsf.renderkit.compiler.RendererInvoker;
import org.ajax4jsf.renderkit.compiler.ResourceElement;
import org.ajax4jsf.renderkit.compiler.StaticInvoker;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class MethodCallElement
extends ElementBase {
    public static final String UTILS_PREFIX = "utils.";
    static final Log _log = LogFactory.getLog(MethodCallElement.class);
    private String _name = null;
    private List parameters = new ArrayList();
    private Invoker invoker = new Invoker();
    private MethodCacheState state = new MethodCacheState();
    static Map staticInvokers = new HashMap();
    static Map rendererInvokers = new HashMap();
    static Map utilsInvokers = new HashMap();

    public void encode(TemplateContext context) throws IOException {
        this.getValue(context);
    }

    public void encode(TemplateContext context, String breakPoint) throws IOException {
        this.encode(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(TemplateContext context) throws FacesException {
        this.state.init(this.parameters);
        Object[] values = this.state.computeParameterValues(context);
        InvokeData data = null;
        MethodCacheState methodCacheState = this.state;
        synchronized (methodCacheState) {
            this.state.update(context, values, this.invoker);
            data = this.invoker.invokeMethod(context, this.state);
        }
        return this.invoker.invokeMethod(data);
    }

    public void addParameter(MethodParameterElement parameter) {
        this.parameters.add(parameter);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String methodName) {
        if (methodName.startsWith(UTILS_PREFIX)) {
            this._name = methodName.substring(UTILS_PREFIX.length());
            this.invoker = this.getRendererUtilsInvoker(this._name);
        } else if (methodName.indexOf(46) >= 0) {
            this._name = methodName;
            this.invoker = this.getStaticInvoker(this._name);
        } else {
            this._name = methodName;
            this.invoker = this.getRendererInvoker(this._name);
        }
    }

    public StaticInvoker getStaticInvoker(String methodName) {
        StaticInvoker invoker = (StaticInvoker)staticInvokers.get(methodName);
        if (invoker == null) {
            invoker = new StaticInvoker(methodName);
            staticInvokers.put(methodName, invoker);
        }
        return invoker;
    }

    public RendererInvoker getRendererInvoker(String methodName) {
        RendererInvoker invoker = (RendererInvoker)rendererInvokers.get(methodName);
        if (invoker == null) {
            invoker = new RendererInvoker(false, methodName);
            rendererInvokers.put(methodName, invoker);
        }
        return invoker;
    }

    public RendererInvoker getRendererUtilsInvoker(String methodName) {
        RendererInvoker invoker = (RendererInvoker)utilsInvokers.get(methodName);
        if (invoker == null) {
            invoker = new RendererInvoker(true, methodName);
            utilsInvokers.put(methodName, invoker);
        }
        return invoker;
    }

    public String getTag() {
        return "f:call";
    }

    public void setParent(PreparedTemplate parent) throws SAXException {
        super.setParent(parent);
        if (this.getName() == null) {
            throw new SAXException(Messages.getMessage("NO_NAME_ATTRIBUTE_ERROR", this.getTag()));
        }
    }

    public String getString(TemplateContext context) throws FacesException {
        Object result = this.getValue(context);
        if (null == result || result.toString().length() == 0) {
            result = "";
        }
        return result.toString();
    }

    protected Class[] getAllowedClasses() {
        return new Class[]{MethodParameterElement.class, ResourceElement.class};
    }
}

