/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.ChameleonRenderer;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RendererBase
extends Renderer
implements ChameleonRenderer {
    protected static final String JAVASCRIPT_NAMESPACE = "Exadel";
    private static final Log log = LogFactory.getLog(RendererBase.class);
    private static final RendererUtils utils = RendererUtils.getInstance();
    private SkinFactory skinFactory = null;
    private InternetResourceBuilder resourceBuilder = null;

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage("CONTEXT_NULL_ERROR", "decode"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage("COMPONENT_NULL_ERROR", "decode"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage("COMPONENT_CLASS_ERROR", "", this.getComponentClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("START_DECODING_COMPONENT_INFO", component.getClientId(context), component.getClass().getName()));
        }
        this.preDecode(context, component);
        if (component.isRendered()) {
            this.doDecode(context, component);
        }
    }

    protected void preDecode(FacesContext context, UIComponent component) {
    }

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage("CONTEXT_NULL_ERROR", "encodeBegin"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage("COMPONENT_NULL_ERROR", "encodeBegin"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage("COMPONENT_CLASS_ERROR", component.getClientId(context), this.getComponentClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("START_ENCODING_COMPONENT_INFO", component.getClientId(context), component.getClass().getName()));
        }
        this.preEncodeBegin(context, component);
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeBegin(writer, context, component);
        }
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage("CONTEXT_NULL_ERROR", "encodeBegin"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage("COMPONENT_NULL_ERROR", "encodeBegin"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage("COMPONENT_CLASS_ERROR", component.getClientId(context), this.getComponentClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("CHILDREN_ENCODING_COMPONENT_INFO", component.getClientId(context), component.getClass().getName()));
        }
        this.preEncodeBegin(context, component);
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeChildren(writer, context, component);
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage("CONTEXT_NULL_ERROR", "encodeEnd"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage("COMPONENT_NULL_ERROR", "encodeEnd"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage("COMPONENT_CLASS_ERROR", component.getClientId(context), this.getComponentClass().getName()));
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeEnd(writer, context, component);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("FINISH_ENCODING_COMPONENT_INFO", component.getClientId(context), component.getClass().getName()));
        }
    }

    @Override
    public InternetResource getResource(String resourceURI) throws FacesException {
        return this.getResourceBuilder().createResource(this, resourceURI);
    }

    private InternetResourceBuilder getResourceBuilder() {
        if (this.resourceBuilder == null) {
            this.resourceBuilder = InternetResourceBuilder.getInstance();
        }
        return this.resourceBuilder;
    }

    protected Skin getSkin(FacesContext context) {
        if (this.skinFactory == null) {
            this.skinFactory = SkinFactory.getInstance();
        }
        return this.skinFactory.getSkin(context);
    }

    public RendererUtils getUtils() {
        return utils;
    }

    protected abstract Class<? extends UIComponent> getComponentClass();

    protected void doDecode(FacesContext context, UIComponent component) {
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void addResource(String key, InternetResource resource) {
        this.getResourceBuilder().addResource(key, resource);
    }

    public void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    public void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }
}

