/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxContainer;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.renderkit.AjaxChildrenRenderer;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxContainerRenderer
extends AjaxChildrenRenderer {
    public static final String AJAX_PARAMETER_NAME = "AJAXREQUEST";
    public static final String AJAX_JSF_SCRIPT = "AJAX.js";
    public static final String SARISSA_SCRIPT = "sarissa.js";
    public static final String JSDOM_SCRIPT = "JSDOM_sarissa.js";
    public static final String AJAX_VIEW_STATE_TAG = "span";
    public static final String AJAX_VIEW_STATE_ID = "ajax-view-state";
    public static final String AJAX_RESULT_GROUP_TAG = "meta";
    public static final String AJAX_RESULT_GROUP_ATTR = "content";
    public static final String AJAX_RESULT_STYLE = "display: none";
    public static final String AJAX_UPDATE_HEADER = "Ajax-Update-Ids";
    static final Log log = LogFactory.getLog(AjaxContainerRenderer.class);
    public static final String AJAX_FLAG_HEADER = "Ajax-Response";
    public static final String AJAX_LOCATION_HEADER = "Location";

    protected Class getComponentClass() {
        return AjaxContainer.class;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        log.debug(Messages.getMessage("RENDER_CHILDREN_NON_AJAX_INFO"));
        this.renderChildren(context, component);
    }

    public void encodeAjax(FacesContext context, UIComponent component) throws IOException {
        log.debug(Messages.getMessage("RENDER_CHILDREN_AJAX_INFO"));
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        Set<String> ids = ajaxContext.getAjaxAreasToRender();
        Set<String> renderedAreas = ajaxContext.getAjaxRenderedAreas();
        UIComponent root = ((AjaxContainer)((Object)component)).isRenderRegionOnly() ? component : context.getViewRoot();
        String path = AjaxRendererUtils.getAbsoluteId(root);
        path = path.substring(0, path.lastIndexOf(58) + 1);
        if (this.isParentRendered(root)) {
            this.encodeAjaxComponent(context, root, path, ids, renderedAreas);
        }
        AjaxRendererUtils.encodeAreas(context, component);
    }

    public boolean isParentRendered(UIComponent target) {
        for (UIComponent component = target; component != null; component = component.getParent()) {
            if (component.isRendered()) continue;
            return false;
        }
        return true;
    }

    public boolean getRendersChildren() {
        return false;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map<String, String> paramMap = context.getExternalContext().getRequestParameterMap();
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("DECODE_AJAX_REQUEST_STATUS_INFO", clientId));
        }
        String ajaxParameter = paramMap.get(AJAX_PARAMETER_NAME);
        AjaxContainer ajaxContainer = (AjaxContainer)((Object)component);
        if (null != ajaxParameter && ajaxParameter.equals(clientId)) {
            ajaxContainer.setSubmitted(true);
            if (ajaxContainer.isSelfRendered()) {
                AjaxContext.getCurrentInstance(context).setSelfRender(true);
            }
            AjaxEvent event = new AjaxEvent(component);
            component.queueEvent(event);
        } else {
            ajaxContainer.setSubmitted(false);
        }
    }
}

