/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.renderkit.AjaxComponentRendererBase;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AjaxCommandRendererBase
extends AjaxComponentRendererBase {
    private static final Log _log = LogFactory.getLog(AjaxCommandRendererBase.class);

    protected void doDecode(FacesContext facesContext, UIComponent uiComponent) {
        if (this.isSubmitted(facesContext, uiComponent)) {
            AjaxComponent ajaxComponent;
            Set<String> toProcess;
            ActionEvent event = new ActionEvent(uiComponent);
            uiComponent.queueEvent(event);
            uiComponent.queueEvent(new AjaxEvent(uiComponent));
            if (uiComponent instanceof AjaxComponent && null != (toProcess = AjaxRendererUtils.asSet((ajaxComponent = (AjaxComponent)((Object)uiComponent)).getProcess()))) {
                LinkedHashSet<String> componentIdsToProcess = new LinkedHashSet<String>();
                for (String componentId : toProcess) {
                    UIComponent component = this.getUtils().findComponentFor(uiComponent, componentId);
                    if (null != component) {
                        componentIdsToProcess.add(component.getClientId(facesContext));
                        continue;
                    }
                    componentIdsToProcess.add(componentId);
                }
                AjaxContext.getCurrentInstance(facesContext).setAjaxAreasToProcess(componentIdsToProcess);
            }
        }
    }

    public String getOnClick(FacesContext context, UIComponent component) {
        StringBuffer onClick;
        if (!this.getUtils().isBooleanAttribute(component, "disabled")) {
            onClick = AjaxRendererUtils.buildOnClick(component, context, true);
            if (!"reset".equals(component.getAttributes().get("type"))) {
                onClick.append(";return false;");
            }
        } else {
            onClick = new StringBuffer("return false;");
        }
        return onClick.toString();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    public Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof ValueHolder) {
            return ((ValueHolder)((Object)uiComponent)).getValue();
        }
        return uiComponent.getAttributes().get("value");
    }

    public String getType(UIComponent uiComponent) {
        String type = uiComponent instanceof HtmlCommandButton ? ((HtmlCommandButton)uiComponent).getType() : (String)uiComponent.getAttributes().get("type");
        if (type == null) {
            type = "button";
        }
        return type;
    }

    protected boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        boolean submitted;
        if (!AjaxContext.getCurrentInstance(facesContext).isAjaxRequest()) {
            return false;
        }
        if (this.getUtils().isBooleanAttribute(uiComponent, "disabled")) {
            return false;
        }
        String clientId = uiComponent.getClientId(facesContext);
        Map<String, String> paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String value = paramMap.get(clientId);
        boolean bl = submitted = null != value;
        if (submitted && _log.isDebugEnabled()) {
            _log.debug("Decode submit of the Ajax component " + clientId);
        }
        return submitted;
    }
}

