/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxChildrenEncoder;
import org.ajax4jsf.component.AjaxOutput;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.renderkit.AjaxComponentRendererBase;
import org.ajax4jsf.renderkit.AjaxRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxChildrenRenderer
extends AjaxComponentRendererBase
implements AjaxRenderer {
    public static final Log log = LogFactory.getLog(AjaxChildrenRenderer.class);
    public static final String[] SPECIAL_COMPONENTS_TYPES = new String[]{"org.ajax4jsf.Bundle", "org.apache.myfaces.AliasBean", "org.apache.myfaces.AliasBeansScope"};
    private static final String SPECIAL_TYPES_PARAMETER = "org.ajax4jsf.CONTROL_COMPONENTS";
    private Set<String> _specialComponentTypes = null;

    @Override
    public void encodeAjaxChildren(FacesContext context, UIComponent component, String path, Set<String> ids, Set<String> renderedAreas) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("ENCODE_CHILD_AJAX_INFO", path, component.getId()));
        }
        String currentPath = path;
        if (component instanceof NamingContainer) {
            currentPath = currentPath + component.getId() + ':';
            if (AjaxContext.getCurrentInstance(context).isLimitToList() && this.noIdUnderPath(path, ids)) {
                return;
            }
        }
        Iterator<UIComponent> it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent element = it.next();
            this.encodeAjaxComponent(context, element, currentPath, ids, renderedAreas);
        }
    }

    private boolean noIdUnderPath(String path, Set<String> ids) {
        boolean noSuchId = true;
        for (String id : ids) {
            if (null == id || !id.startsWith(path)) continue;
            noSuchId = false;
            break;
        }
        return noSuchId;
    }

    @Override
    public void encodeAjaxComponent(FacesContext context, UIComponent component, String currentPath, Set<String> ids, Set<String> renderedAreas) throws IOException {
        if (component.isRendered()) {
            boolean found = false;
            boolean limitToList = AjaxContext.getCurrentInstance(context).isLimitToList();
            String elementId = component.getId();
            String absoluteId = currentPath + elementId;
            if (!ids.isEmpty() && (ids.contains(absoluteId) || ids.contains(elementId))) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("RENDER_AJAX_AREA_INFO", absoluteId));
                }
                found = true;
            }
            if (!found && limitToList && component instanceof NamingContainer && this.noIdUnderPath(absoluteId + ':', ids)) {
                return;
            }
            if (!found && !limitToList && component instanceof AjaxOutput && ((AjaxOutput)((Object)component)).isAjaxRendered()) {
                found = true;
            }
            if (!found) {
                if (component instanceof AjaxChildrenEncoder) {
                    ((AjaxChildrenEncoder)((Object)component)).encodeAjaxChild(context, currentPath, ids, renderedAreas);
                } else {
                    boolean special = this.isSpecialElement(context, component);
                    if (special) {
                        component.encodeBegin(context);
                    }
                    this.encodeAjaxChildren(context, component, currentPath, ids, renderedAreas);
                    if (special) {
                        component.encodeEnd(context);
                    }
                }
            } else {
                renderedAreas.add(component.getClientId(context));
                this.renderChild(context, component);
            }
        }
    }

    private boolean isSpecialElement(FacesContext context, UIComponent component) {
        boolean result;
        if (this._specialComponentTypes == null) {
            this._specialComponentTypes = new HashSet<String>(10);
            for (int i = 0; i < SPECIAL_COMPONENTS_TYPES.length; ++i) {
                this._specialComponentTypes.add(SPECIAL_COMPONENTS_TYPES[i]);
            }
            String special = context.getExternalContext().getInitParameter(SPECIAL_TYPES_PARAMETER);
            if (null != special) {
                String[] split = special.split(",");
                for (int i = 0; i < split.length; ++i) {
                    this._specialComponentTypes.add(split[i]);
                }
            }
        }
        try {
            String componentType = (String)component.getClass().getField("COMPONENT_TYPE").get(null);
            result = this._specialComponentTypes.contains(componentType);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

