/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.Renderer;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxContainer;
import org.ajax4jsf.component.AjaxRegionBrige;
import org.ajax4jsf.component.InvokerCallbackWrapper;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.InvokerCallback;
import org.ajax4jsf.context.ViewIdHolder;
import org.ajax4jsf.event.AjaxListener;
import org.ajax4jsf.event.EventsQueue;
import org.ajax4jsf.renderkit.AjaxContainerRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxViewRoot
extends UIViewRoot
implements AjaxContainer {
    public static final String ROOT_ID = "_viewRoot";
    private Lifecycle lifecycle;
    private AjaxRegionBrige _brige;
    private static final Log _log = LogFactory.getLog(AjaxViewRoot.class);
    private List<PhaseListener> phaseListeners = null;
    private EventsQueue[] events;
    private EventsQueue ajaxEvents = new EventsQueue();
    private InvokerCallback _decodeInvoker = new InvokerCallback(){

        public void invokeContextCallback(FacesContext context, UIComponent component) {
            component.processDecodes(context);
        }

        public void invokeRoot(FacesContext context) {
            AjaxViewRoot.this.decode(context);
        }
    };
    private InvokerCallback _updatesInvoker = new InvokerCallback(){

        public void invokeContextCallback(FacesContext context, UIComponent component) {
            component.processUpdates(context);
        }

        public void invokeRoot(FacesContext context) {
        }
    };
    private InvokerCallback _validatorsInvoker = new InvokerCallback(){

        public void invokeContextCallback(FacesContext context, UIComponent component) {
            component.processValidators(context);
        }

        public void invokeRoot(FacesContext context) {
        }
    };
    private ContextCallback _ajaxInvoker = new ContextCallback(){

        public void invokeContextCallback(FacesContext context, UIComponent component) {
            try {
                if (component instanceof AjaxContainer) {
                    AjaxContainer ajax = (AjaxContainer)((Object)component);
                    ajax.encodeAjax(context);
                } else {
                    AjaxViewRoot.this.encodeAjax(context);
                }
            }
            catch (IOException e) {
                throw new FacesException(e);
            }
        }
    };

    public AjaxViewRoot() {
        super.setId(ROOT_ID);
        this._brige = new AjaxRegionBrige(this);
    }

    public String getRendererType() {
        return "javax.faces.ViewRoot";
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        this.getBrige().broadcast(event);
    }

    public MethodExpression getAjaxListener() {
        return this.getBrige().getAjaxListener();
    }

    public boolean isImmediate() {
        return this.getBrige().isImmediate();
    }

    public boolean isSubmitted() {
        return this.getBrige().isSubmitted();
    }

    public void removePhaseListener(PhaseListener toRemove) {
        if (null != this.phaseListeners) {
            this.phaseListeners.remove(toRemove);
        }
        super.removePhaseListener(toRemove);
    }

    public void addPhaseListener(PhaseListener newPhaseListener) {
        if (null == this.phaseListeners) {
            this.phaseListeners = new ArrayList<PhaseListener>();
        }
        this.phaseListeners.add(newPhaseListener);
        super.addPhaseListener(newPhaseListener);
    }

    protected void processPhaseListeners(FacesContext context, PhaseId phase, boolean before) {
        MethodExpression listenerExpression = before ? this.getBeforePhaseListener() : this.getAfterPhaseListener();
        PhaseEvent event = null;
        if (null != listenerExpression) {
            event = this.createPhaseEvent(context, phase);
            listenerExpression.invoke(context.getELContext(), new Object[]{event});
        }
        if (null != this.phaseListeners) {
            for (PhaseListener listener : this.phaseListeners) {
                PhaseId phaseId = listener.getPhaseId();
                if (phaseId != phase && phaseId != PhaseId.ANY_PHASE) continue;
                if (null == event) {
                    event = this.createPhaseEvent(context, phase);
                }
                if (before) {
                    listener.beforePhase(event);
                    continue;
                }
                listener.afterPhase(event);
            }
        }
    }

    protected PhaseEvent createPhaseEvent(FacesContext context, PhaseId phaseId) throws FacesException {
        if (this.lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = context.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        return new PhaseEvent(context, phaseId, this.lifecycle);
    }

    protected void processPhase(FacesContext context, PhaseId phase, InvokerCallback callback) {
        this.processPhaseListeners(context, phase, true);
        if (null != callback && !context.getRenderResponse() && !context.getResponseComplete()) {
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
            String submittedRegionClientId = ajaxContext.getSubmittedRegionClientId();
            if (ajaxContext.isAjaxRequest() && submittedRegionClientId != null && !submittedRegionClientId.equals(ROOT_ID) && !submittedRegionClientId.equals(this.getClientId(context))) {
                this.invokeOnComponent(context, submittedRegionClientId, new InvokerCallbackWrapper(callback));
            } else {
                try {
                    callback.invokeRoot(context);
                }
                catch (RuntimeException e) {
                    context.renderResponse();
                    throw e;
                }
                String ajaxSingleClientId = ajaxContext.getAjaxSingleClientId();
                if (null == ajaxSingleClientId) {
                    Iterator<UIComponent> iter = this.getFacetsAndChildren();
                    while (iter.hasNext()) {
                        callback.invokeContextCallback(context, iter.next());
                    }
                } else {
                    Set<String> areasToProcess;
                    InvokerCallbackWrapper invokerCallback = new InvokerCallbackWrapper(callback);
                    boolean invoked = this.invokeOnComponent(context, ajaxSingleClientId, invokerCallback);
                    if (!invoked) {
                        _log.warn("No component found to process as 'ajaxSingle' for clientId " + ajaxSingleClientId);
                    }
                    if (null != (areasToProcess = ajaxContext.getAjaxAreasToProcess())) {
                        for (String areaId : areasToProcess) {
                            boolean areaProcessed = this.invokeOnComponent(context, areaId, invokerCallback);
                            if (areaProcessed) continue;
                            _log.warn("No component found to process for clientId " + ajaxSingleClientId);
                        }
                    }
                }
            }
        }
        this.broadcastEvents(context, phase);
        this.processPhaseListeners(context, phase, false);
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException(Messages.getMessage("NULL_EVENT_SUBMITTED_ERROR"));
        }
        if (event.getPhaseId().compareTo(PhaseId.RENDER_RESPONSE) == 0) {
            this.getAjaxEventsQueue().offer(event);
        } else {
            this.getEventsQueue(event.getPhaseId()).offer(event);
        }
    }

    void broadcastEvents(FacesContext context, PhaseId phaseId) {
        EventsQueue[] events = this.getEvents();
        EventsQueue anyPhaseEvents = events[PhaseId.ANY_PHASE.getOrdinal()];
        EventsQueue phaseEvents = events[phaseId.getOrdinal()];
        if (phaseEvents.isEmpty() && anyPhaseEvents.isEmpty()) {
            return;
        }
        boolean haveAnyPhaseEvents = !anyPhaseEvents.isEmpty();
        boolean havePhaseEvents = !phaseEvents.isEmpty();
        do {
            this.processEvents(context, anyPhaseEvents, haveAnyPhaseEvents);
            this.processEvents(context, phaseEvents, havePhaseEvents);
            haveAnyPhaseEvents = !anyPhaseEvents.isEmpty();
            boolean bl = havePhaseEvents = !phaseEvents.isEmpty();
        } while (haveAnyPhaseEvents || havePhaseEvents);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processEvents(FacesContext context, EventsQueue phaseEventsQueue, boolean havePhaseEvents) {
        while (havePhaseEvents) {
            try {
                FacesEvent event = (FacesEvent)phaseEventsQueue.remove();
                UIComponent source = event.getComponent();
                try {
                    source.broadcast(event);
                }
                catch (AbortProcessingException e) {
                    if (!_log.isErrorEnabled()) continue;
                    UIComponent component = event.getComponent();
                    String id = null != component ? component.getClientId(context) : "";
                    _log.error("Error processing faces event for the component " + id, e);
                }
            }
            catch (NoSuchElementException e) {
                havePhaseEvents = false;
            }
        }
    }

    public void broadcastAjaxEvents(FacesContext context) {
        EventsQueue queue;
        this.processEvents(context, queue, !(queue = this.getAjaxEventsQueue()).isEmpty());
    }

    protected EventsQueue getEventsQueue(PhaseId phase) {
        return this.getEvents()[phase.getOrdinal()];
    }

    protected EventsQueue[] getEvents() {
        if (this.events == null) {
            this.clearEvents();
        }
        return this.events;
    }

    protected EventsQueue getAjaxEventsQueue() {
        return this.ajaxEvents;
    }

    public void clearEvents() {
        int len = PhaseId.VALUES.size();
        this.events = new EventsQueue[len];
        for (int i = 0; i < len; ++i) {
            this.events[i] = new EventsQueue();
        }
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.processPhase(context, PhaseId.APPLY_REQUEST_VALUES, this._decodeInvoker);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.processPhase(context, PhaseId.UPDATE_MODEL_VALUES, this._updatesInvoker);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.processPhase(context, PhaseId.PROCESS_VALIDATIONS, this._validatorsInvoker);
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.processPhase(context, PhaseId.INVOKE_APPLICATION, null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        Renderer renderer;
        this.processPhaseListeners(context, PhaseId.RENDER_RESPONSE, true);
        String rendererType = this.getRendererType();
        if (rendererType != null && (renderer = this.getRenderer(context)) != null) {
            renderer.encodeBegin(context, this);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        Renderer renderer;
        String rendererType = this.getRendererType();
        if (rendererType != null && (renderer = this.getRenderer(context)) != null) {
            renderer.encodeEnd(context, this);
        }
        this.processPhaseListeners(context, PhaseId.RENDER_RESPONSE, false);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        if (ajaxContext.isAjaxRequest()) {
            String submittedRegionClientId = ajaxContext.getSubmittedRegionClientId();
            boolean invoked = false;
            if (submittedRegionClientId != null && !submittedRegionClientId.equals(ROOT_ID) && !submittedRegionClientId.equals(this.getClientId(context))) {
                invoked = this.invokeOnComponent(context, submittedRegionClientId, this._ajaxInvoker);
            }
            if (!invoked) {
                this.encodeAjax(context);
            }
        } else {
            super.encodeChildren(context);
        }
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] mystate = (Object[])state;
        super.restoreState(context, mystate[0]);
        this.getBrige().restoreState(context, mystate[1]);
        Object listeners = AjaxViewRoot.restoreAttachedState(context, mystate[2]);
        if (null != listeners) {
            this.phaseListeners = (List)listeners;
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.getBrige().saveState(context), AjaxViewRoot.saveAttachedState(context, this.phaseListeners)};
        return state;
    }

    public String getViewId() {
        ViewIdHolder viewIdHolder = AjaxContext.getCurrentInstance().getViewIdHolder();
        String viewId = null != viewIdHolder ? viewIdHolder.getViewId() : super.getViewId();
        return viewId;
    }

    public void setAjaxListener(MethodExpression ajaxListener) {
        this.getBrige().setAjaxListener(ajaxListener);
    }

    public void setImmediate(boolean immediate) {
        this.getBrige().setImmediate(immediate);
    }

    public void setSubmitted(boolean submitted) {
        this.getBrige().setSubmitted(submitted);
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener(listener);
    }

    public AjaxListener[] getAjaxListeners() {
        return (AjaxListener[])this.getFacesListeners(AjaxListener.class);
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener(listener);
    }

    public boolean isSelfRendered() {
        return false;
    }

    public void setSelfRendered(boolean selfRendered) {
    }

    public boolean getRendersChildren() {
        FacesContext context = FacesContext.getCurrentInstance();
        return AjaxContext.getCurrentInstance(context).isAjaxRequest();
    }

    public boolean isRenderRegionOnly() {
        return false;
    }

    public void setRenderRegionOnly(boolean reRenderPage) {
    }

    public void encodeAjax(FacesContext context) throws IOException {
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            ((AjaxContainerRenderer)this.getRenderer(context)).encodeAjax(context, this);
        }
    }

    protected AjaxRegionBrige getBrige() {
        return this._brige;
    }
}

