/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheEntry;
import org.ajax4jsf.cache.CacheException;
import org.ajax4jsf.cache.CacheListener;
import org.ajax4jsf.cache.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCacheCache
implements Cache {
    private com.opensymphony.oscache.base.Cache cache;
    private CacheLoader cacheLoader;

    public OSCacheCache(com.opensymphony.oscache.base.Cache cache, CacheLoader cacheLoader) {
        this.cache = cache;
        this.cacheLoader = cacheLoader;
    }

    @Override
    public void addListener(CacheListener listener) {
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return null;
    }

    @Override
    public void evict() {
    }

    @Override
    public Object get(Object key, Object context) throws CacheException {
        String keyString = key.toString();
        try {
            return this.cache.getFromCache(keyString);
        }
        catch (NeedsRefreshException e) {
            Object object = this.cacheLoader.load(key, context);
            try {
                this.cache.putInCache(keyString, object);
            }
            catch (Exception e1) {
                this.cache.cancelUpdate(keyString);
                throw new CacheException(e1.getMessage(), e1);
            }
            return object;
        }
    }

    @Override
    public CacheEntry getCacheEntry(Object key) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<Object> keySet() {
        return null;
    }

    @Override
    public void load(Object key, Object context) throws CacheException {
        this.cacheLoader.load(key, context);
    }

    @Override
    public Object peek(Object key) {
        String keyString = key.toString();
        try {
            return this.cache.getFromCache(keyString);
        }
        catch (NeedsRefreshException e) {
            this.cache.cancelUpdate(keyString);
            return null;
        }
    }

    @Override
    public Object put(Object key, Object value) {
        this.cache.putInCache(key.toString(), value);
        return value;
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        String keyString = key.toString();
        try {
            Object object = this.peek(keyString);
            return object;
        }
        finally {
            this.cache.removeEntry(keyString);
        }
    }

    @Override
    public void removeListener(CacheListener listener) {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }
}

