/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class DebugOutputMaker {
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    public static final HashSet IGNORE_ATTRIBUTES = new HashSet();
    private static final String LOGFILE_PARAM = "org.ajax4jsf.LOGFILE";

    public void writeErrorMessage(FacesContext context, Throwable e, String phase) throws FacesException {
        PrintWriter out;
        HttpServletRequest request;
        HttpServletResponse response;
        if (null == context) {
            throw new FacesException(Messages.getMessage("FACES_CONTEXT_NOT_CREATED"), e);
        }
        ExternalContext externalContext = context.getExternalContext();
        if (null == externalContext) {
            throw new FacesException(Messages.getMessage("FACES_CONTEXT_HAS_NOT_EXTERNAL"), e);
        }
        try {
            response = (HttpServletResponse)externalContext.getResponse();
            request = (HttpServletRequest)externalContext.getRequest();
            response.setContentType("text/html;charset=UTF-8");
            response.setStatus(500);
        }
        catch (Exception er) {
            throw new FacesException(Messages.getMessage("FACES_CONTEXT_HAS_NOT_RESPONSE"), e);
        }
        try {
            out = response.getWriter();
        }
        catch (IOException e1) {
            throw new FacesException(e1.getMessage(), e);
        }
        UIViewRoot viewRoot = context.getViewRoot();
        String viewId = null != viewRoot ? viewRoot.getViewId() : request.getRequestURL().toString();
        out.println("<html><head><title>" + Messages.getMessage("ERROR_ON_PAGE", viewId) + "</title></head><body>");
        this.writeScriptAndStyle(out);
        PhaseId facesPhase = (PhaseId)context.getExternalContext().getRequestMap().get("org.ajax4jsf.CURRENT_PHASE");
        String errorMessage = facesPhase == null ? Messages.getMessage("LIFECYCLE_ERROR", viewId, phase) : Messages.getMessage("LIFECYCLE_ERROR_AT_PHASE", new Object[]{viewId, phase, facesPhase.toString()});
        out.println("<h1 >");
        out.println(errorMessage);
        out.println("</h1>");
        response.setHeader("Ajax-Error-Message", errorMessage + ",\n caused by " + e.getClass().getName() + ", with message: " + e.getMessage());
        this.writeExceptionStack(e, out);
        if (null != viewRoot) {
            this.writeComponentsTree(context, out);
        } else {
            out.print("<h2 class=' a4j_debug'> " + Messages.getMessage("COMPONENT_TREE_NOT_CREATED") + " </h2>");
        }
        this.writeContextVariables(context, out);
        this.writeLog(context, out);
        out.println("</body></html>");
        out.flush();
        out.close();
    }

    public void writeExceptionStack(Throwable e, PrintWriter out) {
        out.println("<h2 class=\"a4j_debug\">Exceptions: </h2>");
        Throwable error = e;
        int errorId = 0;
        String caused = "exception ";
        while (null != error) {
            out.print("<h3 onclick=\"toggle('exception" + errorId + "')\"  class='exception a4j_debug'>");
            this.writeToggleMark(out, "exception" + errorId);
            out.print(caused + error.getClass().getName() + " : " + error.getMessage() + "</h3>");
            out.println("<div id='exception" + errorId + "' style='display: none;' class='exception'><p>Exception stack :</p><pre>");
            StackTraceElement[] stackTrace = error.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                out.print("  at " + stackTrace[i].getClassName());
                out.print("." + stackTrace[i].getMethodName());
                out.println(" in " + stackTrace[i].getFileName() + " line " + stackTrace[i].getLineNumber());
            }
            out.println("</pre></div>");
            error = error.getCause();
            caused = "caused by ";
            ++errorId;
        }
    }

    public void writeContextVariables(FacesContext context, PrintWriter out) {
        out.print("<h2  class=\"a4j_debug\" onclick=\"toggle('variables')\">");
        this.writeToggleMark(out, "variables");
        out.println("Faces variables: </h2><div id='variables' style='display: none;'  class='variables a4j_debug'>");
        this.writeVariables(out, context);
        out.println("</div>");
    }

    public void writeComponentsTree(FacesContext context, PrintWriter out) {
        out.print("<h2 class=\"a4j_debug\" onclick=\"toggle('tree')\">");
        this.writeToggleMark(out, "tree");
        out.println("Component tree: </h2><div id='tree' style='display: none;'  class='tree a4j_debug'><dl>");
        this.writeComponent(context, out, context.getViewRoot(), null);
        out.println("</dl></div>");
    }

    public void writeScriptAndStyle(PrintWriter out) {
        this.writeScript(out);
        this.writeStyleSheet(out);
    }

    public void writeLog(FacesContext context, PrintWriter out) throws FacesException {
        String logname = context.getExternalContext().getInitParameter(LOGFILE_PARAM);
        if (null != logname) {
            InternetResource logResource = InternetResourceBuilder.getInstance().createResource(this, logname);
            out.print("<h2 onclick=\"toggle('log')\" class=\"a4j_debug\">");
            this.writeToggleMark(out, "log");
            out.println("Faces log: </h2><div id='log' style='display: none;'  class='log a4j_debug'>");
            out.print("<iframe name='log' class='log' src='" + logResource.getUri(context, null) + "'><a href='src='" + logResource.getUri(context, null) + "'>Faces log file </a> </iframe>");
            out.println("</div>");
        }
    }

    public void writeToggleMark(PrintWriter out, String id) {
        out.print("<span style=\"display:none;\" id=\"" + id + "_expanded\" >-&nbsp;</span>");
        out.print("<span style=\"display:inline;\" id=\"" + id + "_collapsed\" >+</span>&nbsp;");
    }

    private void writeComponent(FacesContext context, PrintWriter out, UIComponent component, String facetName) {
        String clientId = "_tree:" + component.getClientId(context);
        out.println("<dt onclick=\"toggle('" + clientId + "')\" class='tree'>");
        this.writeToggleMark(out, clientId);
        if (null != facetName) {
            out.print("Facet:'" + facetName + "' ");
        }
        out.println("<code>" + component.getClass().getName() + "</code> Id:[" + component.getId() + "]");
        out.println("</dt>");
        out.println("<dd id='" + clientId + "' style='display:none;'   class='tree' ><ul   class='tree'>");
        try {
            PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors(component);
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                if (!PropertyUtils.isReadable(component, propertyDescriptors[i].getName())) continue;
                String name = propertyDescriptors[i].getName();
                ValueBinding vb = component.getValueBinding(name);
                if (vb != null) {
                    this.writeAttribute(out, name, vb.getExpressionString());
                    continue;
                }
                if (IGNORE_ATTRIBUTES.contains(name)) continue;
                try {
                    String value = BeanUtils.getProperty(component, name);
                    this.writeAttribute(out, name, value);
                    continue;
                }
                catch (Exception e) {
                    this.writeAttribute(out, name, null);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Map.Entry<String, Object> entry : component.getAttributes().entrySet()) {
            this.writeAttribute(out, entry.getKey(), entry.getValue());
        }
        out.println("</ul></dd>");
        if (component.getFacetsAndChildren().hasNext()) {
            out.println("<dd class='tree_childs'><dl class='tree_childs'>");
            for (Map.Entry<String, UIComponent> entry : component.getFacets().entrySet()) {
                this.writeComponent(context, out, entry.getValue(), entry.getKey());
            }
            for (UIComponent child : component.getChildren()) {
                this.writeComponent(context, out, child, null);
            }
            out.println("</dl></dd>");
        }
    }

    private void writeAttribute(PrintWriter out, String name, Object value) {
        if (IGNORE_ATTRIBUTES.contains(name)) {
            return;
        }
        if (name.startsWith("javax.faces.webapp.UIComponentTag.")) {
            name = name.substring("javax.faces.webapp.UIComponentTag.".length());
        }
        out.print("<li>");
        out.print(name);
        out.print("=\"");
        if (value != null) {
            if (value instanceof UIComponent) {
                out.print("[id:");
                out.print(((UIComponent)value).getId());
                out.print(']');
            } else if (value instanceof MethodBinding) {
                out.print(((MethodBinding)value).getExpressionString());
            } else if (value instanceof ValueBinding) {
                out.print(((ValueBinding)value).getExpressionString());
            } else {
                out.print(value.toString());
            }
        } else {
            out.print("NULL");
        }
        out.println("\"</li>");
    }

    private void writeVariables(PrintWriter out, FacesContext faces) {
        ExternalContext ctx = faces.getExternalContext();
        this.writeVariables(out, ctx.getRequestParameterMap(), "Request Parameters");
        this.writeVariables(out, ctx.getRequestMap(), "Request Attributes");
        if (ctx.getSession(false) != null) {
            this.writeVariables(out, ctx.getSessionMap(), "Session Attributes");
        }
        this.writeVariables(out, ctx.getApplicationMap(), "Application Attributes");
    }

    private void writeVariables(PrintWriter out, Map vars, String caption) {
        out.print("<table><caption>");
        out.print(caption);
        out.println("</caption><thead><tr><th style=\"width: 10%; \">Name</th><th style=\"width: 90%; \">Value</th></tr></thead><tbody>");
        boolean written = false;
        if (!vars.isEmpty()) {
            TreeMap map = new TreeMap(vars);
            Map.Entry entry2 = null;
            String key = null;
            for (Map.Entry entry2 : map.entrySet()) {
                key = entry2.getKey().toString();
                if (key.indexOf(46) != -1) continue;
                out.println("<tr><td>");
                out.println(key.replaceAll("<", LT).replaceAll(">", GT));
                out.println("</td><td><span class='value'>");
                Object value = entry2.getValue();
                out.println(value.toString().replaceAll("<", LT).replaceAll(">", GT));
                out.println("</span>");
                try {
                    PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors(value);
                    if (propertyDescriptors.length > 0) {
                        out.print("<div class='properties'><ul class='properties'>");
                        for (int i = 0; i < propertyDescriptors.length; ++i) {
                            String beanPropertyName = propertyDescriptors[i].getName();
                            if (!PropertyUtils.isReadable(value, beanPropertyName)) continue;
                            out.print("<li class='properties'>");
                            out.print(beanPropertyName + " = " + BeanUtils.getProperty(value, beanPropertyName));
                            out.print("</li>");
                        }
                        out.print("</ul></div>");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                out.println("</td></tr>");
                written = true;
            }
        }
        if (!written) {
            out.println("<tr><td colspan=\"2\"><em>None</em></td></tr>");
        }
        out.println("</tbody></table>");
    }

    private void writeScript(PrintWriter out) {
        out.println("<script type='text/javascript' language='javascript'>\nfunction toggle(id) {\nvar style = document.getElementById(id).style;\nif ('block' == style.display) {\nstyle.display = 'none';\ndocument.getElementById(id+'_collapsed').style.display = 'inline';\ndocument.getElementById(id+'_expanded').style.display = 'none';\n} else {\nstyle.display = 'block';\ndocument.getElementById(id+'_collapsed').style.display = 'none';\ndocument.getElementById(id+'_expanded').style.display = 'inline';\n}\n}\n\n</script>");
    }

    private void writeStyleSheet(PrintWriter out) {
        out.println("<style type='text/css' >\ndiv.a4j_debug, .a4j_debug span, .a4j_debug td, .a4j_debug th, .a4j_debug caption { font-family: Verdana, Arial, Sans-Serif; }\n.a4j_debug li{\n   list-style-position : inside;\n}\n\n.a4j_debug li, .a4j_debug pre { padding: 0; margin: 0;  font-size : 12px;}\n.a4j_debug ul { padding: 0 0 10 0; margin: 0;  font-size : 12px;}\n.a4j_debug h1 { color: #fff; background-color : #a00; font-size : 17px; padding : 7px 10px 10px 10px}\nh2.a4j_debug , h2.a4j_debug  span { color: #a00;  font-size : 17px; padding : 0px 0px 0px 10px;}\nh2.a4j_debug  a { text-decoration: none; color: #a00; }\n.exception { color: #000;  font-size : 14px; padding : 0px 0px 0px 10px;}\n.grayBox { padding: 8px; margin: 10px 0; border: 1px solid #CCC; background-color: #f9f9f9;   font-size : 12px; }\n#error { color: #900; font-weight: bold; font-size: medium; }\n#trace, #tree, #vars { display: none; }\n.a4j_debug code { font-size: medium;   font-size : 14px;}\n#tree dl { color: #666; }\n#tree dd {   font-size : 12px;}\n#tree dt { border: 1px solid #DDD; padding: 2px 4px 4px 4px; border-left: 2px solid #a00; font-family: \"Courier New\", Courier, mono; font-size: small;   font-size : 12px; margin-top: 2px; margin-bottom: 2px;}\n.uicText { color: #999;  }\n.a4j_debug table { border: 1px solid #CCC; border-collapse: collapse; border-spacing: 0px; width: 100%; text-align: left; }\n.a4j_debug td { border: 1px solid #CCC;    font-size : 12px; vertical-align : top}\n.a4j_debug thead tr th { padding: 2px; color: #030; background-color: #F9F9F9;   font-size : 12px;}\n.a4j_debug tbody tr td { padding: 10px 6px; }\n.a4j_debug table caption { text-align: left; padding: 20 0 5 0; font-size : 12px; font-weight : bold;}\n.value {font-size : 12px; font-weight : bold;}\ndiv.log { width: 100%; height: 400px;}\niframe.log { width: 99%; height: 99%; border: 1px solid #CCC;}\n</style>");
    }

    static {
        IGNORE_ATTRIBUTES.add("attributes");
        IGNORE_ATTRIBUTES.add("children");
        IGNORE_ATTRIBUTES.add("childCount");
        IGNORE_ATTRIBUTES.add("class");
        IGNORE_ATTRIBUTES.add("facets");
        IGNORE_ATTRIBUTES.add("facetsAndChildren");
        IGNORE_ATTRIBUTES.add("parent");
        IGNORE_ATTRIBUTES.add("actionListeners");
        IGNORE_ATTRIBUTES.add("valueChangeListeners");
        IGNORE_ATTRIBUTES.add("validators");
        IGNORE_ATTRIBUTES.add("rowData");
        IGNORE_ATTRIBUTES.add("javax.faces.webapp.COMPONENT_IDS");
        IGNORE_ATTRIBUTES.add("javax.faces.webapp.FACET_NAMES");
        IGNORE_ATTRIBUTES.add("javax.faces.webapp.CURRENT_VIEW_ROOT");
    }
}

