/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolverChainWrapper
extends ELResolver {
    private PropertyResolver legacyPR = null;

    public PropertyResolverChainWrapper(PropertyResolver propertyResolver) {
        this.legacyPR = propertyResolver;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws ELException {
        Object result;
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ELContext jsfEL = facesContext.getELContext();
        jsfEL.setPropertyResolved(true);
        if (base instanceof List || base.getClass().isArray()) {
            Object indexObj = facesContext.getApplication().getExpressionFactory().coerceToType(property, Integer.class);
            int index = (Integer)indexObj;
            try {
                result = this.legacyPR.getValue(base, index);
            }
            catch (EvaluationException ex) {
                context.setPropertyResolved(false);
                throw new ELException(ex);
            }
        }
        try {
            result = this.legacyPR.getValue(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException(ex);
        }
        context.setPropertyResolved(jsfEL.isPropertyResolved());
        return result;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws ELException {
        Class result;
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ELContext jsfEL = facesContext.getELContext();
        jsfEL.setPropertyResolved(true);
        if (base instanceof List || base.getClass().isArray()) {
            Object indexObj = facesContext.getApplication().getExpressionFactory().coerceToType(property, Integer.class);
            int index = (Integer)indexObj;
            try {
                result = this.legacyPR.getType(base, index);
            }
            catch (EvaluationException ex) {
                context.setPropertyResolved(false);
                throw new ELException(ex);
            }
        }
        try {
            result = this.legacyPR.getType(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException(ex);
        }
        context.setPropertyResolved(jsfEL.isPropertyResolved());
        return result;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object val) throws ELException {
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ELContext jsfEL = facesContext.getELContext();
        jsfEL.setPropertyResolved(true);
        if (base instanceof List || base.getClass().isArray()) {
            Object indexObj = facesContext.getApplication().getExpressionFactory().coerceToType(property, Integer.class);
            int index = (Integer)indexObj;
            try {
                this.legacyPR.setValue(base, index, val);
            }
            catch (EvaluationException ex) {
                context.setPropertyResolved(false);
                throw new ELException(ex);
            }
        }
        try {
            this.legacyPR.setValue(base, property, val);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException(ex);
        }
        context.setPropertyResolved(jsfEL.isPropertyResolved());
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws ELException {
        boolean result;
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ELContext jsfEL = facesContext.getELContext();
        jsfEL.setPropertyResolved(true);
        if (base instanceof List || base.getClass().isArray()) {
            Object indexObj = facesContext.getApplication().getExpressionFactory().coerceToType(property, Integer.class);
            int index = (Integer)indexObj;
            try {
                result = this.legacyPR.isReadOnly(base, index);
            }
            catch (EvaluationException ex) {
                context.setPropertyResolved(false);
                throw new ELException(ex);
            }
        }
        try {
            result = this.legacyPR.isReadOnly(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException(ex);
        }
        context.setPropertyResolved(jsfEL.isPropertyResolved());
        return result;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return Object.class;
        }
        return null;
    }
}

