from .cgc_exploit import CGCExploit
from .c_templates import c_template_type1

import logging

l = logging.getLogger("rex.exploit.cgc.cgc_type1_exploit")


class CGCType1Exploit(CGCExploit):
    '''
    A CGC exploit object, offers more flexibility than an Exploit object for
    the sake of the game. This should represent a Type 1 POV by allowing you
    to set many different registers to many different values.
    https://github.com/CyberGrandChallenge/cgc-release-documentation/blob/master/walk-throughs/understanding-cfe-povs.md
    '''

    registers = ["eax", "ecx", "edx", "ebx", "esp", "ebp", "esi", "edi"]

    def __init__(self, crash, register, bypasses_nx, bypasses_aslr,
                 reg_bitmask, ip_bitmask):
        '''
        :param crash: a crash object which has been modified to exploit a
        vulnerability
        :param register: register name which this exploit sets
        :param bypasses_nx: does this exploit bypass NX?
        :param bypasses_aslr: does this exploit bypass ASLR?
        :param reg_bitmask: how many bits of the register can it set?
        :param ip_bitmask: how many bits of the ip can it set?
        '''
        super(CGCType1Exploit, self).__init__(crash, 1, bypasses_nx,
                                              bypasses_aslr)

        self.register = register
        self._reg_bitmask = reg_bitmask
        self._ip_bitmask = ip_bitmask

    @staticmethod
    def _hex_escape(s):
        new_s = []
        for c in s:
            new_s.append("\\x%02x" % c)

        return ''.join(new_s)

    def dump_c(self, filename=None):
        """
        Creates a simple C file to do the type1 exploit
        :param filename: dumps the code to this path if filename is not None
        :return: the c_code
        """

        fmt_args = dict()
        fmt_args["register"] = self.register
        fmt_args["regmask"] = hex(self._reg_bitmask)
        fmt_args["ipmask"] = hex(self._ip_bitmask)
        fmt_args["payload_len"] = hex(self._payload_len)
        fmt_args["raw_payload"] = self._hex_escape(self._raw_payload)
        fmt_args["solver_code"] = self._solver_code
        fmt_args["recv_buf_len"] = hex(self._recv_buf_len)
        # int stuff
        fmt_args["payload_int_start_locations"] = self._make_c_int_arr([x.start for x in self._sorted_stdin_int_infos])
        fmt_args["payload_int_bases"] = self._make_c_int_arr([x.base for x in self._sorted_stdin_int_infos])
        fmt_args["payload_int_expected_lens"] = self._make_c_int_arr([x.size for x in self._sorted_stdin_int_infos])
        fmt_args["recv_int_start_locations"] = self._make_c_int_arr([x.start for x in self._sorted_stdout_int_infos])
        fmt_args["recv_int_bases"] = self._make_c_int_arr([x.base for x in self._sorted_stdout_int_infos])
        fmt_args["recv_int_expected_lens"] = self._make_c_int_arr([x.size for x in self._sorted_stdout_int_infos])
        fmt_args["num_payload_ints"] = str(len(self._sorted_stdin_int_infos))
        fmt_args["num_recv_ints"] = str(len(self._sorted_stdout_int_infos))

        # TODO using .format is annoying because of all the curly braces
        # figure out how to do this better
        c_code = c_template_type1.c_template
        for k, v in fmt_args.items():
            c_code = c_code.replace("{%s}" % k, v)

        if filename is not None:
            with open(filename, 'w') as f:
                f.write(c_code)
        else:
            return c_code
