# RESTler Fuzzing

In *Fuzz-lean* mode, RESTler executes once every endpoint+method in a compiled RESTler grammar with a default set of checkers to see if bugs can be found quickly.

In *Fuzz* mode, RESTler will fuzz the service under test during a longer period of time with the goal of finding more bugs and issues (resource leaks, perf degradation, backend corruptions, etc.). **Warning:** The Fuzz mode is the more aggressive and may create outages in the service under test if the service is poorly implemented.
**Warning** By default, RESTler will not fuzz all value combinations in `fuzz` mode.  You must change the `fuzzing_mode` to `bfs` in order to test all combinations of values provided 
in the dictionary, enum values, etc.


Inputs: (same as for test)

1. a grammar.py file generated by the RESTler compiler

2. a RESTler fuzzing dictionary in JSON format

3. a configuration file and/or script that may be used to obtain a fresh authentication token, if required by your API.   Authentication is the same as described in [Testing](Testing.md).


## How to invoke RESTler in fuzz-lean or fuzz mode

```C:\restler_bin\restler\restler.exe fuzz-lean --grammar_file <RESTLer grammar.py file> --dictionary_file <RESTler fuzzing-dictionary.json file> --token_refresh_interval <time in seconds> --token_refresh_command <command>```

```C:\restler_bin\restler\restler.exe fuzz --grammar_file <RESTLer grammar.py file> --dictionary_file <RESTler fuzzing-dictionary.json file> --token_refresh_interval <time in seconds> --token_refresh_command <command> --time_budget <max number of hours (default 1)```

An optional settings file can also be passed to RESTler by adding the command-line option `--settings <path_to_settings_file.json>`.
For a list of available settings, see [SettingsFile](SettingsFile.md).

Outputs: see the sub-directory `FuzzLean` or `Fuzz` (similar to `Test`)

RESTLer will generate a sub-directory `Fuzz[Lean]\RestlerResults\experiment<GUID>\logs` including the following files:

- `bug_buckets.txt` reports bugs found by RESTler. Those bugs are either "500 Internal Server Errors" found by the RESTler "main_driver" or property checker violations

    RESTler currently detects these different types of bugs:

    - "500 Internal Server Errors" and any other 5xx errors are detected by the "main_driver"

    - UseAfterFreeChecker detects that a deleted resource can still being accessed after deletion

    - NameSpaceRuleChecker detects that an unauthorized user can access service resources

    - ResourceHierarchyChecker detects that a child resource can be accessed from a non-parent resource

    - LeakageRuleChecker detects that a failed resource creation leaks data in subsequent requests

    - InvalidDynamicObjectChecker detects 500 errors or unexpected success status codes when invalid dynamic objects are sent in requests

    - PayloadBodyChecker detects 500 errors when fuzzing the JSON bodies of requests

RESTler will also generate a sub-directory Fuzz\ResponseBuckets including the following files:

- `runSummary.json` is a report on all the HTTP error response codes that were received

- `errorBuckets.json` includes a sample of up to 10 pairs of <request, response> for each HTTP error codes in the 4xx or 5xx ranges that were received

Additionally, if any bugs were found, RESTler will generate the sub-directory `Fuzz[Lean]\RestlerResults\experiment<GUID>\bug_buckets`,
which will include a new file for each unique bug found.
This log displays the actual request strings sent to the server as part of the sequence.
These logs are replayable with RESTler using its Replay functionality.
See [BugBuckets](BugBuckets.md) for a more details on bug buckets, and [Replay](Replay.md) for how to reproduce the bugs.