/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class IOToolkit {
    public static byte[] readStream(int length, InputStream is) throws IOException {
        int i;
        byte[] buf = new byte[length];
        for (int read = 0; read < length; read += i) {
            i = is.read(buf, read, length - read);
            if (i != -1) continue;
            throw new IOException("No more bytes left.");
        }
        return buf;
    }

    public static void writeStream(InputStream is, OutputStream os) throws IOException {
        int i;
        byte[] buf = new byte[4096];
        while ((i = is.read(buf)) != -1) {
            os.write(buf, 0, i);
        }
    }

    public static void updateCRCWithStream(InputStream is, CRC32 crc) throws IOException {
        int i;
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buf = new byte[256];
        while ((i = bis.read(buf)) != -1) {
            crc.update(buf, 0, i);
        }
    }

    public static boolean areEqual(InputStream isA, InputStream isB) throws IOException {
        byte[] bufA = new byte[256];
        byte[] bufB = new byte[256];
        block0: while (true) {
            int countB;
            int countA;
            if ((countA = isA.read(bufA)) != (countB = isB.read(bufB))) {
                return false;
            }
            if (countA == -1) break;
            int i = 0;
            while (true) {
                if (i >= countA) continue block0;
                if (bufA[i] != bufB[i]) {
                    return false;
                }
                ++i;
            }
            break;
        }
        return true;
    }
}

