/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.util;

import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteToolkit;

public class ByteArrayByteParser
implements ByteParser {
    protected byte[] data;
    protected int pos = 0;
    protected boolean bigEndian = false;

    public ByteArrayByteParser(byte[] data) {
        this.data = data;
    }

    public ByteArrayByteParser(byte[] data, int pos) {
        this.data = data;
        this.pos = pos;
    }

    public byte getByte() {
        return this.data[this.pos++];
    }

    public byte[] getBytes(int count) {
        byte[] bytes = ByteToolkit.getBytes(this.data, this.pos, count);
        this.pos += count;
        return bytes;
    }

    public int getByteAsInt() {
        return ByteToolkit.getByte(this.data[this.pos++]);
    }

    public int getShortAsInt() {
        int i = (int)ByteToolkit.getLong(this.data, this.pos, 2, this.bigEndian);
        this.pos += 2;
        return i;
    }

    public long getInt() {
        long l = ByteToolkit.getLong(this.data, this.pos, 4, this.bigEndian);
        this.pos += 4;
        return l;
    }

    @Deprecated
    public ByteParser getNewParser() {
        ByteArrayByteParser parser = new ByteArrayByteParser(this.data, this.pos);
        parser.setBigEndian(this.bigEndian);
        return parser;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public boolean hasMore() {
        return this.pos < this.data.length;
    }

    public int getPosition() {
        return this.pos;
    }

    public int peekByte() {
        return ByteToolkit.getByte(this.data[this.pos]);
    }
}

