/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.java.instruction.StackElementType;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _tableswitch
extends Instruction {
    public static final int OPCODE = 170;
    public static final String MNEMONIC = "tableswitch";
    private Label def;
    private int low;
    private int high;
    private Map<Integer, Label> offsets;

    @Override
    public int getOpcode() {
        return 170;
    }

    @Override
    public String getMnemonic() {
        return MNEMONIC;
    }

    @Override
    public int getSize() {
        throw new RuntimeException("Variant sized, getSize() must not be called, use getSize(DecompilationContext) instead.");
    }

    @Override
    public int getSize(DecompilationContext dc) {
        if (this.offsets == null) {
            ByteParser parser = dc.getParser();
            int startPos = parser.getPosition();
            parser.getByte();
            int pad = 0;
            while ((dc.getPosition() + pad + 1) % 4 != 0) {
                parser.getByte();
                ++pad;
            }
            parser.getInt();
            int low = (int)parser.getInt();
            int high = (int)parser.getInt();
            for (int i = low; i <= high; ++i) {
                parser.getInt();
            }
            return parser.getPosition() - startPos;
        }
        int size = 1;
        while ((dc.getPosition() + size) % 4 != 0) {
            ++size;
        }
        size += 12;
        return size += (this.high - this.low + 1) * 4;
    }

    @Override
    public void setData(byte[] data, DecompilationContext dc) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        parser.getByte();
        while ((dc.getPosition() + parser.getPosition()) % 4 != 0) {
            parser.getByte();
        }
        this.def = new Label((int)parser.getInt() + dc.getPosition(), "table_label_def");
        this.low = (int)parser.getInt();
        this.high = (int)parser.getInt();
        this.offsets = new HashMap<Integer, Label>();
        for (int i = this.low; i <= this.high; ++i) {
            Label label = new Label((int)parser.getInt() + dc.getPosition(), "table_label_" + i);
            if (label.getPosition() == this.def.getPosition()) continue;
            this.offsets.put(i, label);
        }
    }

    @Override
    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(170);
        while ((ser.size() + dc.getPosition()) % 4 != 0) {
            ser.addByte(0);
        }
        ser.addInt(this.def.getPosition() - dc.getPosition());
        ser.addInt(this.low);
        ser.addInt(this.high);
        for (int i = this.low; i <= this.high; ++i) {
            Label l = this.offsets.get(i);
            if (l != null) {
                ser.addInt(l.getPosition() - dc.getPosition());
                continue;
            }
            ser.addInt(this.def.getPosition() - dc.getPosition());
        }
        return ser.getBytes();
    }

    @Override
    public void execute(ExecutionContext ec) {
    }

    @Override
    public List<Label> getLabels() {
        ArrayList<Label> al = new ArrayList<Label>();
        al.add(this.def);
        al.addAll(this.offsets.values());
        return al;
    }

    @Override
    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.def);
        params.addValue(this.offsets);
        return params;
    }

    @Override
    public Parameters getParameterTypes() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_LABEL, ParameterType.TYPE_SWITCH});
    }

    @Override
    public void setParameters(Parameters params) {
        this.def = (Label)params.getObject(0);
        this.offsets = (Map)params.getObject(1);
    }

    @Override
    public List<StackElement> getPoppedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("index", StackElementType.INT));
        return elements;
    }
}

