/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.java.instruction.StackElementType;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _newarray
extends Instruction {
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_CHAR = 5;
    public static final int TYPE_FLOAT = 6;
    public static final int TYPE_DOUBLE = 7;
    public static final int TYPE_BYTE = 8;
    public static final int TYPE_SHORT = 9;
    public static final int TYPE_INT = 10;
    public static final int TYPE_LONG = 11;
    public static final int OPCODE = 188;
    public static final String MNEMONIC = "newarray";
    private static final int SIZE = 2;
    private int arrayType = 0;

    public _newarray() {
    }

    public _newarray(int type) {
        this.arrayType = type;
    }

    @Override
    public int getOpcode() {
        return 188;
    }

    @Override
    public String getMnemonic() {
        return MNEMONIC;
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public void execute(ExecutionContext ec) {
    }

    @Override
    public void setData(byte[] data, DecompilationContext dc) {
        this.arrayType = (int)ByteToolkit.getLong(data, 1, 1, true);
    }

    @Override
    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(188);
        ser.addByte(this.arrayType);
        return ser.getBytes();
    }

    @Override
    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.arrayType);
        return params;
    }

    @Override
    public Parameters getParameterTypes() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_ARRAYTYPE});
    }

    @Override
    public void setParameters(Parameters params) {
        this.arrayType = params.getInt(0);
    }

    public static String getTypeName(int arrayType) {
        switch (arrayType) {
            case 4: {
                return "boolean";
            }
            case 8: {
                return "byte";
            }
            case 5: {
                return "char";
            }
            case 7: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 9: {
                return "short";
            }
        }
        throw new RuntimeException("Invalid arraytype value: " + arrayType);
    }

    @Override
    public List<StackElement> getPoppedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("count", StackElementType.INT));
        return elements;
    }

    @Override
    public List<StackElement> getPushedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("arrayref", StackElementType.REF));
        return elements;
    }
}

