/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ExecutionContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;
import net.sf.rej.java.instruction.StackElement;
import net.sf.rej.java.instruction.StackElementType;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _checkcast_quick
extends Instruction {
    public static final int OPCODE = 224;
    public static final String MNEMONIC = "checkcast_quick";
    private static final int SIZE = 3;
    private int index = 0;

    public _checkcast_quick() {
    }

    public _checkcast_quick(int index) {
        this.index = index;
    }

    @Override
    public int getOpcode() {
        return 224;
    }

    @Override
    public String getMnemonic() {
        return MNEMONIC;
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public void execute(ExecutionContext ec) {
    }

    @Override
    public void setData(byte[] data, DecompilationContext dc) {
        this.index = (int)ByteToolkit.getLong(data, 1, 2, true);
    }

    @Override
    public byte[] getData(DecompilationContext dc) {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(224);
        ser.addShort(this.index);
        return ser.getBytes();
    }

    @Override
    public Parameters getParameters() {
        Parameters params = this.getParameterTypes();
        params.addValue(this.index);
        return params;
    }

    @Override
    public Parameters getParameterTypes() {
        return new Parameters(new ParameterType[]{ParameterType.TYPE_CONSTANT_POOL_CLASS});
    }

    @Override
    public void setParameters(Parameters params) {
        this.index = params.getInt(0);
    }

    @Override
    public List<StackElement> getPoppedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("objectref", StackElementType.REF));
        return elements;
    }

    @Override
    public List<StackElement> getPushedElements(DecompilationContext dc) {
        ArrayList<StackElement> elements = new ArrayList<StackElement>();
        elements.add(new StackElement("objectref", StackElementType.REF));
        return elements;
    }
}

