/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.LocalVariable;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.ParameterType;

public class Parameters {
    private List<ParameterType> types = new ArrayList<ParameterType>();
    private List<Object> values = new ArrayList<Object>();
    private boolean readOnly = false;
    public static final Parameters EMPTY_PARAMS = new Parameters(true);

    public Parameters() {
    }

    private Parameters(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Parameters(ParameterType[] types) {
        for (int i = 0; i < types.length; ++i) {
            this.addParam(types[i]);
        }
    }

    public int getCount() {
        return this.types.size();
    }

    public void addParam(ParameterType type) {
        if (this.readOnly) {
            throw new RuntimeException("Modification not allowed.");
        }
        this.types.add(type);
    }

    public void addValue(int i) {
        this.addValue((Object)i);
    }

    public void addValue(Object o) {
        if (this.readOnly) {
            throw new RuntimeException("Modification not allowed.");
        }
        if (this.values.size() + 1 > this.types.size()) {
            throw new RuntimeException("Parameter type/value mismatch; # of types=" + this.types.size() + " trying to insert value #" + this.values.size() + 1);
        }
        this.values.add(o);
    }

    public int getInt(int pos) {
        return (Integer)this.values.get(pos);
    }

    public ParameterType getType(int i) {
        return this.types.get(i);
    }

    public Object getObject(int i) {
        return this.values.get(i);
    }

    public void setValue(int i, Object object) {
        if (i >= this.types.size()) {
            throw new RuntimeException("Parameter type/value mismatch; # of types=" + this.types.size() + " inserting value #" + i + " = " + object);
        }
        this.values.set(i, object);
    }

    public String getString(DecompilationContext dc) {
        StringBuffer sb = new StringBuffer();
        block9: for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            switch (this.getType(i)) {
                case TYPE_ARRAYTYPE: {
                    continue block9;
                }
                case TYPE_LOCAL_VARIABLE: 
                case TYPE_LOCAL_VARIABLE_READONLY: 
                case TYPE_LOCAL_VARIABLE_WIDE: {
                    LocalVariable lv = null;
                    if (dc.getLocalVariableTable() != null) {
                        lv = dc.getLocalVariableTable().getLocalVariable(this.getInt(i), dc.getPosition());
                    }
                    if (lv == null) {
                        sb.append(this.getInt(i));
                        continue block9;
                    }
                    sb.append(lv.getName());
                    continue block9;
                }
                case TYPE_CONSTANT_WIDE: 
                case TYPE_CONSTANT_READONLY: 
                case TYPE_CONSTANT: {
                    sb.append(this.getInt(i));
                    continue block9;
                }
                case TYPE_CONSTANT_POOL_CLASS: {
                    ConstantPoolInfo cpi = dc.getConstantPool().get(this.getInt(i));
                    ClassInfo ci = (ClassInfo)cpi;
                    sb.append(ci.getName());
                    continue block9;
                }
                case TYPE_CONSTANT_POOL_CONSTANT: {
                    ConstantPoolInfo cpi = dc.getConstantPool().get(this.getInt(i));
                    sb.append(cpi.getValue());
                    continue block9;
                }
                case TYPE_CONSTANT_POOL_FIELD_REF: {
                    ConstantPoolInfo cpi = dc.getConstantPool().get(this.getInt(i));
                    RefInfo ri = (RefInfo)cpi;
                    Descriptor desc = ri.getDescriptor();
                    sb.append(desc.getReturn() + " " + ri.getClassName() + "." + ri.getTargetName());
                    continue block9;
                }
                case TYPE_CONSTANT_POOL_METHOD_REF: {
                    ConstantPoolInfo cpi = dc.getConstantPool().get(this.getInt(i));
                    RefInfo ri = (RefInfo)cpi;
                    Descriptor desc = ri.getDescriptor();
                    sb.append(desc.getReturn() + " " + ri.getClassName() + "." + ri.getTargetName() + "(" + desc.getParams() + ")");
                    continue block9;
                }
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            hashCode *= 37;
            hashCode += this.getInt(i);
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Parameters)) {
            return false;
        }
        Parameters op = (Parameters)o;
        if (op.types.size() != this.types.size()) {
            return false;
        }
        for (int i = 0; i < this.types.size(); ++i) {
            if (this.getType(i) != op.getType(i)) {
                return false;
            }
            if (this.getObject(i).equals(op.getObject(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        block9: for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            switch (this.getType(i)) {
                case TYPE_ARRAYTYPE: {
                    sb.append("ArrayType=" + this.getInt(i));
                    continue block9;
                }
                case TYPE_LOCAL_VARIABLE: 
                case TYPE_LOCAL_VARIABLE_READONLY: 
                case TYPE_LOCAL_VARIABLE_WIDE: {
                    sb.append("Local Variable=" + this.getInt(i));
                    continue block9;
                }
                case TYPE_CONSTANT_WIDE: 
                case TYPE_CONSTANT_READONLY: 
                case TYPE_CONSTANT: {
                    sb.append("Constant=" + this.getInt(i));
                    continue block9;
                }
                case TYPE_CONSTANT_POOL_CLASS: {
                    sb.append("Class ref=" + this.getInt(i));
                    continue block9;
                }
                case TYPE_CONSTANT_POOL_CONSTANT: {
                    sb.append("Pool constant=" + this.getInt(i));
                    continue block9;
                }
                case TYPE_CONSTANT_POOL_FIELD_REF: {
                    sb.append("Field ref=" + this.getInt(i));
                    continue block9;
                }
                case TYPE_CONSTANT_POOL_METHOD_REF: {
                    sb.append("Method ref=" + this.getInt(i));
                    continue block9;
                }
            }
        }
        return sb.toString();
    }
}

