/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.instruction;

import net.sf.rej.java.Exceptions;
import net.sf.rej.java.attribute.LocalVariableTableAttribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.util.ByteParser;

public class DecompilationContext {
    private int position = 0;
    private ConstantPool cp;
    private ByteParser parser;
    private Exceptions exceptions = null;
    LocalVariableTableAttribute lvtAttr;

    public void setPosition(int pos) {
        this.position = pos;
    }

    public int getPosition() {
        return this.position;
    }

    public void incrementPosition(Instruction instruction) {
        this.position += instruction.getSize(this);
    }

    public void incrementPosition(int count) {
        this.position += count;
    }

    public void setParser(ByteParser parser) {
        this.parser = parser;
    }

    @Deprecated
    public ByteParser getParser() {
        return this.parser.getNewParser();
    }

    public ConstantPool getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPool cp) {
        this.cp = cp;
    }

    public void setExceptions(Exceptions exceptions) {
        this.exceptions = exceptions;
    }

    public Exceptions getExceptions() {
        return this.exceptions;
    }

    public void setLocalVariableTable(LocalVariableTableAttribute lvtAttr) {
        this.lvtAttr = lvtAttr;
    }

    public LocalVariableTableAttribute getLocalVariableTable() {
        return this.lvtAttr;
    }

    public DecompilationContext createNew() {
        DecompilationContext dc = new DecompilationContext();
        dc.cp = this.cp;
        dc.exceptions = this.exceptions;
        dc.lvtAttr = this.lvtAttr;
        dc.parser = this.parser;
        dc.position = 0;
        return dc;
    }
}

