/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import net.sf.rej.java.Descriptor;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.DescriptorEnabled;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.util.ByteSerializer;

public class NameAndTypeInfo
extends ConstantPoolInfo
implements DescriptorEnabled {
    private int nameIndex;
    private int descriptorIndex;

    public NameAndTypeInfo(int nameIndex, int descriptorIndex, ConstantPool pool) {
        super(12, pool);
        this.nameIndex = nameIndex;
        this.descriptorIndex = descriptorIndex;
    }

    public String toString() {
        Descriptor desc = this.getDescriptor();
        return desc.getReturn() + " " + this.getName() + "(" + desc.getParams() + ")";
    }

    public String getName() {
        return this.pool.get(this.nameIndex).getValue();
    }

    public UTF8Info getNameInfo() {
        return (UTF8Info)this.pool.get(this.nameIndex);
    }

    public String getDescriptorString() {
        return this.pool.get(this.descriptorIndex).getValue();
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        ser.addShort(this.nameIndex);
        ser.addShort(this.descriptorIndex);
        return ser.getBytes();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getDescriptorString().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            NameAndTypeInfo info = (NameAndTypeInfo)other;
            if (!this.getName().equals(info.getName())) {
                return false;
            }
            return this.getDescriptorString().equals(info.getDescriptorString());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public Descriptor getDescriptor() {
        return new Descriptor(this.getDescriptorString());
    }

    public void setDescriptorIndex(int index) {
        this.descriptorIndex = index;
    }

    public String getTypeString() {
        return "Name and type";
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }
}

