/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteSerializer;

public class LongInfo
extends ConstantPoolInfo {
    private long value;

    public LongInfo(long value, ConstantPool pool) {
        super(5, pool);
        this.value = value;
    }

    public LongInfo(long highBytes, long lowBytes, ConstantPool pool) {
        super(5, pool);
        this.value = (highBytes << 32) + lowBytes;
    }

    public String toString() {
        return "(long) " + String.valueOf(this.value);
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        ser.addInt(this.value >> 32);
        ser.addInt(this.value & 0xFFFFFFFFL);
        return ser.getBytes();
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            return this.value == ((LongInfo)other).value;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String getTypeString() {
        return "Long constant";
    }

    public long getLongValue() {
        return this.value;
    }

    public void setLongValue(long newValue) {
        this.value = newValue;
    }
}

