/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteSerializer;

public class IntegerInfo
extends ConstantPoolInfo {
    private int value;

    public IntegerInfo(int value, ConstantPool pool) {
        super(3, pool);
        this.value = value;
    }

    public String toString() {
        return "(int) " + String.valueOf(this.value);
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        ser.addInt(this.value);
        return ser.getBytes();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            return this.value == ((IntegerInfo)other).value;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String getTypeString() {
        return "Integer constant";
    }

    public int getIntValue() {
        return this.value;
    }

    public void setIntValue(int value) {
        this.value = value;
    }
}

