/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteSerializer;

public class FloatInfo
extends ConstantPoolInfo {
    private int bytes;

    public FloatInfo(int bytes, ConstantPool pool) {
        super(4, pool);
        this.bytes = bytes;
    }

    public FloatInfo(float value, ConstantPool pool) {
        super(4, pool);
        this.setFloatValue(value);
    }

    public String toString() {
        return "(float) " + String.valueOf(this.getFloatValue());
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addByte(this.getType());
        ser.addInt(this.bytes);
        return ser.getBytes();
    }

    public int hashCode() {
        return this.bytes;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            return this.bytes == ((FloatInfo)other).bytes;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String getTypeString() {
        return "Float constant";
    }

    public float getFloatValue() {
        return Float.intBitsToFloat(this.bytes);
    }

    public void setFloatValue(float value) {
        this.bytes = Float.floatToRawIntBits(value);
    }

    public int getBytes() {
        return this.bytes;
    }
}

