/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import java.util.Arrays;
import junit.framework.TestCase;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.DoubleInfo;
import net.sf.rej.util.ByteToolkit;
import org.junit.Assert;
import org.junit.Test;

public class DoubleInfoTest
extends TestCase {
    @Test
    public final void testGetData() {
        DoubleInfo di = new DoubleInfo(0L, 0L, new ConstantPool());
        byte[] data = di.getData();
        byte[] expected = new byte[]{6, 0, 0, 0, 0, 0, 0, 0, 0};
        try {
            Assert.assertTrue((String)"0", (boolean)Arrays.equals(expected, data));
        }
        catch (AssertionError ae) {
            System.out.println("Expected: " + ByteToolkit.byteArrayToDebugString(expected));
            System.out.println("Result: " + ByteToolkit.byteArrayToDebugString(data));
            throw ae;
        }
        di = new DoubleInfo(0L, 19L, new ConstantPool());
        data = di.getData();
        expected = new byte[]{6, 0, 0, 0, 0, 0, 0, 0, 19};
        try {
            Assert.assertTrue((String)"19", (boolean)Arrays.equals(expected, data));
        }
        catch (AssertionError ae) {
            System.out.println("Expected: " + ByteToolkit.byteArrayToDebugString(expected));
            System.out.println("Result: " + ByteToolkit.byteArrayToDebugString(data));
            throw ae;
        }
        di = new DoubleInfo(0L, 258L, new ConstantPool());
        data = di.getData();
        expected = new byte[]{6, 0, 0, 0, 0, 0, 0, 1, 2};
        try {
            Assert.assertTrue((String)"258", (boolean)Arrays.equals(expected, data));
        }
        catch (AssertionError ae) {
            System.out.println("Expected: " + ByteToolkit.byteArrayToDebugString(expected));
            System.out.println("Result: " + ByteToolkit.byteArrayToDebugString(data));
            throw ae;
        }
    }

    @Test
    public final void testGetTypeString() {
        ConstantPool cp = new ConstantPool();
        DoubleInfo di = new DoubleInfo(0.0, cp);
        Assert.assertEquals((String)"type string", (Object)"Double constant", (Object)di.getTypeString());
    }

    @Test
    public final void testDoubleInfoIntConstantPool() {
        DoubleInfo di = new DoubleInfo(0L, 0L, new ConstantPool());
        Assert.assertEquals((String)"0 high bytes", (Object)0L, (Object)di.getHighBytes());
        Assert.assertEquals((String)"0 low bytes", (Object)0L, (Object)di.getLowBytes());
        di = new DoubleInfo(0L, 1L, new ConstantPool());
        Assert.assertEquals((String)"0 high bytes", (Object)0L, (Object)di.getHighBytes());
        Assert.assertEquals((String)"1 low bytes", (Object)1L, (Object)di.getLowBytes());
        di = new DoubleInfo(2L, 1L, new ConstantPool());
        Assert.assertEquals((String)"2 high bytes", (Object)2L, (Object)di.getHighBytes());
        Assert.assertEquals((String)"1 low bytes", (Object)1L, (Object)di.getLowBytes());
    }

    @Test
    public final void testDoubleInfoDoubleConstantPool() {
        DoubleInfo di = new DoubleInfo(0.0, new ConstantPool());
        Assert.assertEquals((String)"0.0d", (Object)0.0, (Object)di.getDoubleValue());
        di = new DoubleInfo(1.1, new ConstantPool());
        Assert.assertEquals((String)"1.1d", (Object)1.1, (Object)di.getDoubleValue());
        di = new DoubleInfo(-1.1, new ConstantPool());
        Assert.assertEquals((String)"-1.1d", (Object)-1.1, (Object)di.getDoubleValue());
    }

    @Test
    public final void testEqualsObject() {
        DoubleInfo a = new DoubleInfo(0.0, new ConstantPool());
        Assert.assertTrue((String)"same instance", (boolean)a.equals(a));
        DoubleInfo b = new DoubleInfo(0.0, new ConstantPool());
        Assert.assertTrue((String)"both zero a.equals(b)", (boolean)a.equals(b));
        Assert.assertTrue((String)"both zero b.equals(a)", (boolean)b.equals(a));
        b.setDoubleValue(1.0);
        Assert.assertFalse((String)"a=0, b=1 a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=0, b=1 b.equals(a)", (boolean)b.equals(a));
        a.setDoubleValue(Double.NaN);
        Assert.assertFalse((String)"a=NaN, b=1 a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=NaN, b=1 b.equals(a)", (boolean)b.equals(a));
        b.setDoubleValue(Double.NaN);
        Assert.assertTrue((String)"a=NaN, b=NaN a.equals(b)", (boolean)a.equals(b));
        Assert.assertTrue((String)"a=NaN, b=NaN b.equals(a)", (boolean)b.equals(a));
        a.setDoubleValue(Double.POSITIVE_INFINITY);
        Assert.assertFalse((String)"a=positive inf, b=NaN a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=positive inf, b=NaN b.equals(a)", (boolean)b.equals(a));
        b.setDoubleValue(3.5);
        a.setDoubleValue(Double.NEGATIVE_INFINITY);
        Assert.assertFalse((String)"a=negative inf, b=3.5d a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=negative inf, b=3.5d b.equals(a)", (boolean)b.equals(a));
        b.setDoubleValue(3.5);
        a.setDoubleValue(3.5);
        Assert.assertTrue((String)"a=3.5d, b=3.5d a.equals(b)", (boolean)a.equals(b));
        Assert.assertTrue((String)"a=3.5d, b=3.5d b.equals(a)", (boolean)b.equals(a));
        a.setDoubleValue(-3.5);
        Assert.assertFalse((String)"a=-3.5d, b=3.5d a.equals(b)", (boolean)a.equals(b));
        Assert.assertFalse((String)"a=-3.5d, b=3.5d b.equals(a)", (boolean)b.equals(a));
    }

    @Test
    public final void testGetDoubleValue() {
        ConstantPool cp = new ConstantPool();
        DoubleInfo di = new DoubleInfo(1.0, cp);
        Assert.assertEquals((String)"1.0d", (Object)1.0, (Object)di.getDoubleValue());
        di = new DoubleInfo(0.0, cp);
        Assert.assertEquals((String)"0.0d", (Object)0.0, (Object)di.getDoubleValue());
        di = new DoubleInfo(-1.0, cp);
        Assert.assertEquals((String)"-1.0d", (Object)-1.0, (Object)di.getDoubleValue());
        di = new DoubleInfo(618.8, cp);
        Assert.assertEquals((String)"618.8d", (Object)618.8, (Object)di.getDoubleValue());
        di = new DoubleInfo(Double.NEGATIVE_INFINITY, cp);
        Assert.assertEquals((String)"negative indinity", (Object)Double.NEGATIVE_INFINITY, (Object)di.getDoubleValue());
        di = new DoubleInfo(Double.POSITIVE_INFINITY, cp);
        Assert.assertEquals((String)"positive indinity", (Object)Double.POSITIVE_INFINITY, (Object)di.getDoubleValue());
        di = new DoubleInfo(Double.NaN, cp);
        Assert.assertEquals((String)"not a number", (Object)Double.NaN, (Object)di.getDoubleValue());
    }

    @Test
    public final void testSetDoubleValue() {
        ConstantPool cp = new ConstantPool();
        DoubleInfo di = new DoubleInfo(0.0, cp);
        di.setDoubleValue(1.0);
        Assert.assertEquals((String)"1.0d", (Object)1.0, (Object)di.getDoubleValue());
        di.setDoubleValue(0.0);
        Assert.assertEquals((String)"0.0d", (Object)0.0, (Object)di.getDoubleValue());
        di.setDoubleValue(-1.0);
        Assert.assertEquals((String)"-1.0d", (Object)-1.0, (Object)di.getDoubleValue());
        di.setDoubleValue(618.8);
        Assert.assertEquals((String)"618.8d", (Object)618.8, (Object)di.getDoubleValue());
        di.setDoubleValue(Double.NEGATIVE_INFINITY);
        Assert.assertEquals((String)"negative indinity", (Object)Double.NEGATIVE_INFINITY, (Object)di.getDoubleValue());
        di.setDoubleValue(Double.POSITIVE_INFINITY);
        Assert.assertEquals((String)"positive indinity", (Object)Double.POSITIVE_INFINITY, (Object)di.getDoubleValue());
        di.setDoubleValue(Double.NaN);
        Assert.assertEquals((String)"not a number", (Object)Double.NaN, (Object)di.getDoubleValue());
    }

    @Test
    public final void testGetBytes() {
        DoubleInfo di = new DoubleInfo(0L, 0L, new ConstantPool());
        Assert.assertEquals((String)"0 high bytes", (Object)0L, (Object)di.getHighBytes());
        Assert.assertEquals((String)"0 low bytes", (Object)0L, (Object)di.getLowBytes());
        di = new DoubleInfo(0L, 1L, new ConstantPool());
        Assert.assertEquals((String)"0 high bytes", (Object)0L, (Object)di.getHighBytes());
        Assert.assertEquals((String)"1 low bytes", (Object)1L, (Object)di.getLowBytes());
        di = new DoubleInfo(2L, 1L, new ConstantPool());
        Assert.assertEquals((String)"2 high bytes", (Object)2L, (Object)di.getHighBytes());
        Assert.assertEquals((String)"1 low bytes", (Object)1L, (Object)di.getLowBytes());
    }
}

