/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.constantpool;

import java.util.logging.Logger;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.DoubleInfo;
import net.sf.rej.java.constantpool.FloatInfo;
import net.sf.rej.java.constantpool.IntegerInfo;
import net.sf.rej.java.constantpool.LongInfo;
import net.sf.rej.java.constantpool.NameAndTypeInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.java.constantpool.StringInfo;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteToolkit;
import net.sf.rej.util.ParsingException;

public abstract class ConstantPoolInfo {
    private static final Logger logger = Logger.getLogger(ConstantPoolInfo.class.getName());
    public static final int CLASS = 7;
    public static final int FIELD_REF = 9;
    public static final int METHOD_REF = 10;
    public static final int INTERFACE_METHOD_REF = 11;
    public static final int STRING = 8;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int NAME_AND_TYPE = 12;
    public static final int UTF8 = 1;
    private int tag;
    protected ConstantPool pool;

    protected ConstantPoolInfo(int tag, ConstantPool pool) {
        this.tag = tag;
        this.pool = pool;
    }

    public static ConstantPoolInfo getCPI(ByteParser parser, ConstantPool pool) {
        int tag = parser.getByteAsInt();
        switch (tag) {
            case 7: {
                int nameIndex = parser.getShortAsInt();
                return new ClassInfo(nameIndex, pool);
            }
            case 9: 
            case 10: 
            case 11: {
                int classIndex = parser.getShortAsInt();
                int nameAndTypeIndex = parser.getShortAsInt();
                return new RefInfo(tag, classIndex, nameAndTypeIndex, pool);
            }
            case 8: {
                int stringIndex = parser.getShortAsInt();
                return new StringInfo(stringIndex, pool);
            }
            case 3: {
                int i = (int)parser.getInt();
                return new IntegerInfo(i, pool);
            }
            case 4: {
                int f = (int)parser.getInt();
                return new FloatInfo(f, pool);
            }
            case 5: {
                long highBytes = parser.getInt();
                long lowBytes = parser.getInt();
                return new LongInfo(highBytes, lowBytes, pool);
            }
            case 6: {
                long highBytes = parser.getInt();
                long lowBytes = parser.getInt();
                return new DoubleInfo(highBytes, lowBytes, pool);
            }
            case 12: {
                int nameIndex = parser.getShortAsInt();
                int descriptorIndex = parser.getShortAsInt();
                return new NameAndTypeInfo(nameIndex, descriptorIndex, pool);
            }
            case 1: {
                int length = parser.getShortAsInt();
                byte[] bytes = parser.getBytes(length);
                return new UTF8Info(bytes, pool);
            }
        }
        byte[] asdf = parser.getBytes(32);
        logger.warning("Unsupported/invalid constantpool entry: " + tag);
        logger.warning(ByteToolkit.byteArrayToDebugString(asdf));
        throw new ParsingException("Unsupported contstantpool entry: " + tag);
    }

    public int getType() {
        return this.tag;
    }

    public String getValue() {
        return this.toString();
    }

    public abstract byte[] getData();

    public abstract String getTypeString();
}

