/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute.generics;

import java.util.List;
import junit.framework.TestCase;
import net.sf.rej.java.attribute.generics.Any;
import net.sf.rej.java.attribute.generics.BoundTypeArgument;
import net.sf.rej.java.attribute.generics.ClassSignature;
import net.sf.rej.java.attribute.generics.FieldSignature;
import net.sf.rej.java.attribute.generics.FormalTypeParameter;
import net.sf.rej.java.attribute.generics.GenericJavaType;
import net.sf.rej.java.attribute.generics.MethodSignature;
import net.sf.rej.java.attribute.generics.Signatures;
import net.sf.rej.java.attribute.generics.TypeArgument;
import net.sf.rej.java.attribute.generics.Types;
import org.junit.Assert;
import org.junit.Test;

public class SignaturesTest
extends TestCase {
    @Test
    public final void testGetClassSignature() {
        ClassSignature cs = Signatures.getClassSignature("Ljava/util/ArrayList<Ljava/lang/String;>;Ljava/io/Serializable;");
        Assert.assertEquals((String)"Superclass", (Object)"java.util.ArrayList<java.lang.String>", (Object)cs.getSuperClassSignature().toString());
        List<GenericJavaType> intfs = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)1, (Object)intfs.size());
        Assert.assertEquals((String)"Interface 1", (Object)"java.io.Serializable", (Object)intfs.get(0).toString());
        cs = Signatures.getClassSignature("<TypeTest:Ljava/lang/Object;>Ljava/lang/Object;");
        FormalTypeParameter gd = cs.getFormalTypeParameters().get(0);
        Assert.assertEquals((String)"Generic def name", (Object)"TypeTest", (Object)gd.getIdentifier());
        Assert.assertEquals((String)"Generic def supertype", (Object)"java.lang.Object", (Object)gd.getClassBound().toString());
        Assert.assertEquals((String)"Superclass", (Object)"java.lang.Object", (Object)cs.getSuperClassSignature().toString());
        List<GenericJavaType> intfs2 = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)0, (Object)intfs2.size());
        cs = Signatures.getClassSignature("<M:Ljava/util/ArrayList;>Ljavax/swing/JPanel;");
        gd = cs.getFormalTypeParameters().get(0);
        Assert.assertEquals((String)"Generic def name", (Object)"M", (Object)gd.getIdentifier());
        Assert.assertEquals((String)"Generic def supertype", (Object)"java.util.ArrayList", (Object)gd.getClassBound().toString());
        Assert.assertEquals((String)"Superclass", (Object)"javax.swing.JPanel", (Object)cs.getSuperClassSignature().toString());
        intfs2 = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)0, (Object)intfs2.size());
        cs = Signatures.getClassSignature("<MMM:Ljava/lang/Object;>Ljava/lang/Object;Ljava/io/Serializable;Lnet/sf/rej/guineapigs/SignaturePig5<Ljava/lang/String;>;");
        gd = cs.getFormalTypeParameters().get(0);
        Assert.assertEquals((String)"Generic def name", (Object)"MMM", (Object)gd.getIdentifier());
        Assert.assertEquals((String)"Generic def supertype", (Object)"java.lang.Object", (Object)gd.getClassBound().toString());
        Assert.assertEquals((String)"Superclass", (Object)"java.lang.Object", (Object)cs.getSuperClassSignature().toString());
        intfs2 = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)2, (Object)intfs2.size());
        Assert.assertEquals((String)"Interface 1", (Object)"java.io.Serializable", (Object)intfs2.get(0).toString());
        Assert.assertEquals((String)"Interface 2", (Object)"net.sf.rej.guineapigs.SignaturePig5<java.lang.String>", (Object)intfs2.get(1).toString());
        cs = Signatures.getClassSignature("<TTT::Ljava/lang/Runnable;:Ljava/lang/Comparable;>Ljava/lang/Object;");
        gd = cs.getFormalTypeParameters().get(0);
        Assert.assertEquals((String)"Generic def name", (Object)"TTT", (Object)gd.getIdentifier());
        Assert.assertNull((String)"Generic supertype", (Object)gd.getClassBound());
        List<GenericJavaType> genIntfs = gd.getInterfaceBounds();
        Assert.assertEquals((String)"Gen Interface count", (Object)2, (Object)genIntfs.size());
        Assert.assertEquals((String)"Gen Interface 1", (Object)"java.lang.Runnable", (Object)genIntfs.get(0).toString());
        Assert.assertEquals((String)"Gen Interface 2", (Object)"java.lang.Comparable", (Object)genIntfs.get(1).toString());
        Assert.assertEquals((String)"Superclass", (Object)"java.lang.Object", (Object)cs.getSuperClassSignature().toString());
        List<GenericJavaType> intfs3 = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)0, (Object)intfs3.size());
        cs = Signatures.getClassSignature("<ABC:Ljavax/swing/JPanel;:Ljava/io/Serializable;:Ljava/lang/Iterable<Ljava/lang/String;>;>Ljavax/swing/JLabel;Ljava/lang/Runnable;");
        gd = cs.getFormalTypeParameters().get(0);
        Assert.assertEquals((String)"Generic def name", (Object)"ABC", (Object)gd.getIdentifier());
        Assert.assertEquals((String)"Generic supertype", (Object)"javax.swing.JPanel", (Object)gd.getClassBound().toString());
        genIntfs = gd.getInterfaceBounds();
        Assert.assertEquals((String)"Gen Interface count", (Object)2, (Object)genIntfs.size());
        Assert.assertEquals((String)"Gen Interface 1", (Object)"java.io.Serializable", (Object)genIntfs.get(0).toString());
        Assert.assertEquals((String)"Gen Interface 2", (Object)"java.lang.Iterable<java.lang.String>", (Object)genIntfs.get(1).toString());
        Assert.assertEquals((String)"Superclass", (Object)"javax.swing.JLabel", (Object)cs.getSuperClassSignature().toString());
        intfs3 = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)1, (Object)intfs3.size());
        Assert.assertEquals((String)"Interface 1", (Object)"java.lang.Runnable", (Object)intfs3.get(0).toString());
        cs = Signatures.getClassSignature("<AAA:Ljava/lang/Object;>Ljava/util/ArrayList<TAAA;>;");
        gd = cs.getFormalTypeParameters().get(0);
        Assert.assertEquals((String)"Generic def name", (Object)"AAA", (Object)gd.getIdentifier());
        Assert.assertEquals((String)"Generic supertype", (Object)"java.lang.Object", (Object)gd.getClassBound().toString());
        genIntfs = gd.getInterfaceBounds();
        Assert.assertEquals((String)"Gen Interface count", (Object)0, (Object)genIntfs.size());
        Assert.assertEquals((String)"Superclass", (Object)"java.util.ArrayList", (Object)cs.getSuperClassSignature().getBaseType().getType());
        List<TypeArgument> typeParams = cs.getSuperClassSignature().getTypeArguments();
        Assert.assertEquals((String)"Type parameter count", (Object)1, (Object)typeParams.size());
        GenericJavaType typeParam1 = (GenericJavaType)typeParams.get(0);
        Assert.assertEquals((String)"Type parameter 1 Type", (Object)((Object)Types.TYPE_PARAMETER_IDENTIFIER), (Object)((Object)typeParam1.getType()));
        Assert.assertEquals((String)"Type parameter 1", (Object)"AAA", (Object)typeParam1.toString());
        List<GenericJavaType> intfs4 = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)0, (Object)intfs4.size());
        cs = Signatures.getClassSignature("<BBB:Ljava/lang/Object;>Ljava/util/ArrayList<[Ljava/lang/String;>;");
        gd = cs.getFormalTypeParameters().get(0);
        Assert.assertEquals((String)"Generic def name", (Object)"BBB", (Object)gd.getIdentifier());
        Assert.assertEquals((String)"Generic supertype", (Object)"java.lang.Object", (Object)gd.getClassBound().toString());
        genIntfs = gd.getInterfaceBounds();
        Assert.assertEquals((String)"Gen Interface count", (Object)0, (Object)genIntfs.size());
        Assert.assertEquals((String)"Superclass", (Object)"java.util.ArrayList", (Object)cs.getSuperClassSignature().getBaseType().getType());
        typeParams = cs.getSuperClassSignature().getTypeArguments();
        Assert.assertEquals((String)"Type parameter count", (Object)1, (Object)typeParams.size());
        typeParam1 = (GenericJavaType)typeParams.get(0);
        Assert.assertEquals((String)"Type parameter 1 Type", (Object)((Object)Types.REFERENCE_TYPE), (Object)((Object)typeParam1.getType()));
        Assert.assertEquals((String)"Type parameter 1 Ref Type", (Object)"java.lang.String", (Object)typeParam1.getBaseType().getType());
        Assert.assertEquals((String)"Type parameter 1 Dimensions", (Object)1, (Object)typeParam1.getBaseType().getDimensionCount());
        intfs4 = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)0, (Object)intfs4.size());
        cs = Signatures.getClassSignature("<CCC1:Ljava/lang/Number;CCC2::Ljava/util/List<Ljava/lang/String;>;>Ljava/lang/Object;");
        List<FormalTypeParameter> typeParams2 = cs.getFormalTypeParameters();
        Assert.assertEquals((String)"Type param count", (Object)2, (Object)typeParams2.size());
        FormalTypeParameter typeParam = typeParams2.get(0);
        Assert.assertEquals((String)"Type param identifier", (Object)"CCC1", (Object)typeParam.getIdentifier());
        Assert.assertEquals((String)"Class bound", (Object)"java.lang.Number", (Object)typeParam.getClassBound().toString());
        List<GenericJavaType> genIntfs2 = typeParam.getInterfaceBounds();
        Assert.assertEquals((String)"Interface bound count", (Object)0, (Object)genIntfs2.size());
        typeParam = typeParams2.get(1);
        Assert.assertEquals((String)"Type param identifier", (Object)"CCC2", (Object)typeParam.getIdentifier());
        Assert.assertNull((String)"No class bound", (Object)typeParam.getClassBound());
        genIntfs2 = typeParam.getInterfaceBounds();
        Assert.assertEquals((String)"Interface bound count", (Object)1, (Object)genIntfs2.size());
        Assert.assertEquals((String)"Interface bound", (Object)"java.util.List<java.lang.String>", (Object)genIntfs2.get(0).toString());
        Assert.assertEquals((String)"Superclass", (Object)"java.lang.Object", (Object)cs.getSuperClassSignature().getBaseType().getType());
        List<TypeArgument> typeArgs = cs.getSuperClassSignature().getTypeArguments();
        Assert.assertEquals((String)"Type argument count", (Object)0, (Object)typeArgs.size());
        intfs3 = cs.getSuperInterfaceSignatures();
        Assert.assertEquals((String)"Interface count", (Object)0, (Object)intfs3.size());
    }

    @Test
    public final void testGetFieldSignature() {
        FieldSignature signature = Signatures.getFieldSignature("TM;");
        Assert.assertEquals((String)"Type type", (Object)((Object)Types.TYPE_PARAMETER_IDENTIFIER), (Object)((Object)signature.getType().getType()));
        Assert.assertEquals((String)"Type name", (Object)"M", (Object)signature.getType().toString());
        signature = Signatures.getFieldSignature("Ljava/util/List<Ljava/lang/String;>;");
        Assert.assertEquals((String)"Type", (Object)"java.util.List<java.lang.String>", (Object)signature.getType().toString());
        signature = Signatures.getFieldSignature("Ljava/util/List<*>;");
        Assert.assertEquals((String)"Type toString", (Object)"java.util.List<*>", (Object)signature.getType().toString());
        List<TypeArgument> typeParams = signature.getType().getTypeArguments();
        Assert.assertEquals((String)"Type param count", (Object)1, (Object)typeParams.size());
        Assert.assertTrue((String)"Type param type is wildcard", (boolean)(typeParams.get(0) instanceof Any));
        signature = Signatures.getFieldSignature("Ljava/util/List<+Ljava/lang/Number;>;");
        Assert.assertEquals((String)"Type toString", (Object)"java.util.List<? extends java.lang.Number>", (Object)signature.getType().toString());
        typeParams = signature.getType().getTypeArguments();
        Assert.assertEquals((String)"Type param count", (Object)1, (Object)typeParams.size());
        Assert.assertTrue((String)"Type param type is bound", (boolean)(typeParams.get(0) instanceof BoundTypeArgument));
        signature = Signatures.getFieldSignature("Ljava/util/Map<+Ljava/lang/Number;-Ljava/util/ArrayList;>;");
        Assert.assertEquals((String)"Type toString", (Object)"java.util.Map<? extends java.lang.Number,? super java.util.ArrayList>", (Object)signature.getType().toString());
        typeParams = signature.getType().getTypeArguments();
        Assert.assertEquals((String)"Type param count", (Object)2, (Object)typeParams.size());
        Assert.assertTrue((String)"Type param 1 type is bound", (boolean)(typeParams.get(0) instanceof BoundTypeArgument));
        Assert.assertTrue((String)"Type param 2 type is bound", (boolean)(typeParams.get(1) instanceof BoundTypeArgument));
    }

    @Test
    public final void testGetMethodSignature() {
        MethodSignature signature = Signatures.getMethodSignature("<H:Ljava/lang/Object;>(TH;)V");
        FormalTypeParameter gd = signature.getFormalTypeParameters().get(0);
        Assert.assertEquals((String)"Generic def name", (Object)"H", (Object)gd.getIdentifier());
        Assert.assertEquals((String)"Generic supertype", (Object)"java.lang.Object", (Object)gd.getClassBound().toString());
        List<GenericJavaType> genIntfs = gd.getInterfaceBounds();
        Assert.assertEquals((String)"Gen Interface count", (Object)0, (Object)genIntfs.size());
        List<GenericJavaType> params = signature.getParameters();
        Assert.assertEquals((String)"Parameter count", (Object)1, (Object)params.size());
        Assert.assertEquals((String)"Parameter 1", (Object)"H", (Object)params.get(0).toString());
        GenericJavaType ret = signature.getReturnType();
        Assert.assertEquals((String)"Return type", (Object)"void", (Object)ret.toString());
        signature = Signatures.getMethodSignature("(Lnet/sf/rej/guineapigs/SignaturePig2<+Ljava/lang/Integer;>;)V");
        Assert.assertNull((String)"Generic def", signature.getFormalTypeParameters());
        List<GenericJavaType> params2 = signature.getParameters();
        Assert.assertEquals((String)"Parameter count", (Object)1, (Object)params2.size());
        Assert.assertEquals((String)"Parameter 1", (Object)"net.sf.rej.guineapigs.SignaturePig2<? extends java.lang.Integer>", (Object)params2.get(0).toString());
        GenericJavaType ret2 = signature.getReturnType();
        Assert.assertEquals((String)"Return type", (Object)"void", (Object)ret2.toString());
        signature = Signatures.getMethodSignature("(Lnet/sf/rej/guineapigs/SignaturePig2<-Ljava/lang/Integer;>;)V");
        Assert.assertNull((String)"Generic def", signature.getFormalTypeParameters());
        params2 = signature.getParameters();
        Assert.assertEquals((String)"Parameter count", (Object)1, (Object)params2.size());
        Assert.assertEquals((String)"Parameter 1", (Object)"net.sf.rej.guineapigs.SignaturePig2<? super java.lang.Integer>", (Object)params2.get(0).toString());
        ret2 = signature.getReturnType();
        Assert.assertEquals((String)"Return type", (Object)"void", (Object)ret2.toString());
    }
}

