/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute.generics;

import java.util.List;
import net.sf.rej.java.attribute.generics.ClassSignature;
import net.sf.rej.java.attribute.generics.FieldSignature;
import net.sf.rej.java.attribute.generics.FormalTypeParameter;
import net.sf.rej.java.attribute.generics.GenericJavaType;
import net.sf.rej.java.attribute.generics.MethodSignature;
import net.sf.rej.java.attribute.generics.Signature;
import net.sf.rej.java.attribute.generics.SignatureParser;

public class Signatures {
    public static ClassSignature getClassSignature(String signatureString) {
        SignatureParser parser = new SignatureParser(signatureString);
        ClassSignature signature = new ClassSignature();
        if (parser.peekNextType() == SignatureParser.ElementType.START_DEF) {
            List<FormalTypeParameter> typeParams = parser.getFormalTypeParameters();
            signature.setFormalTypeParameters(typeParams);
        }
        signature.setSuperClassSignature(parser.getGenericType());
        while (parser.hasMore()) {
            signature.addSuperInterfaceSignature(parser.getGenericType());
        }
        return signature;
    }

    public static FieldSignature getFieldSignature(String signatureString) {
        SignatureParser parser = new SignatureParser(signatureString);
        FieldSignature signature = new FieldSignature(parser.getGenericType());
        return signature;
    }

    public static MethodSignature getMethodSignature(String signatureString) {
        SignatureParser parser = new SignatureParser(signatureString);
        MethodSignature signature = new MethodSignature();
        if (parser.peekNextType() == SignatureParser.ElementType.START_DEF) {
            List<FormalTypeParameter> typeParams = parser.getFormalTypeParameters();
            signature.setFormalTypeParameters(typeParams);
        }
        List<GenericJavaType> params = parser.getMethodParameters();
        signature.setParameters(params);
        GenericJavaType returnType = parser.getGenericType();
        signature.setReturnType(returnType);
        return signature;
    }

    public static Signature getSignature(String signatureString) {
        SignatureParser parser = new SignatureParser(signatureString);
        Signature signature = new Signature();
        if (parser.peekNextType() == SignatureParser.ElementType.START_DEF) {
            List<FormalTypeParameter> typeParams = parser.getFormalTypeParameters();
            signature.setFormalTypeParameters(typeParams);
        }
        if (parser.peekNextType() == SignatureParser.ElementType.START_METHOD_PARAMS) {
            List<GenericJavaType> params = parser.getMethodParameters();
            signature.setParameters(params);
        }
        while (parser.hasMore()) {
            GenericJavaType type = parser.getGenericType();
            signature.addGenericType(type);
        }
        return signature;
    }
}

