/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute.generics;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.attribute.generics.GenericJavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormalTypeParameter {
    private String identifier;
    private GenericJavaType classBound;
    private List<GenericJavaType> interfaceBounds = new ArrayList<GenericJavaType>();

    public FormalTypeParameter(String identifier) {
        this.identifier = identifier;
    }

    public void setClassBound(GenericJavaType type) {
        this.classBound = type;
    }

    public void addInterfaceBound(GenericJavaType type) {
        this.interfaceBounds.add(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier);
        sb.append(" extends ");
        boolean first = true;
        for (GenericJavaType intf : this.getTypeUnion()) {
            if (first) {
                first = false;
            } else {
                sb.append(" & ");
            }
            sb.append(intf);
        }
        return sb.toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public GenericJavaType getClassBound() {
        return this.classBound;
    }

    public List<GenericJavaType> getInterfaceBounds() {
        ArrayList<GenericJavaType> retList = new ArrayList<GenericJavaType>(this.interfaceBounds.size());
        retList.addAll(this.interfaceBounds);
        return retList;
    }

    public List<GenericJavaType> getTypeUnion() {
        ArrayList<GenericJavaType> retList = new ArrayList<GenericJavaType>(this.interfaceBounds.size() + 1);
        if (this.classBound != null) {
            retList.add(this.classBound);
        }
        retList.addAll(this.interfaceBounds);
        return retList;
    }
}

