/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute.annotations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.attribute.annotations.ArrayValue;
import net.sf.rej.java.attribute.annotations.ClassInfoValue;
import net.sf.rej.java.attribute.annotations.ConstantValue;
import net.sf.rej.java.attribute.annotations.ElementValue;
import net.sf.rej.java.attribute.annotations.EnumValue;
import net.sf.rej.java.attribute.annotations.NestedAnnotationValue;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.util.ByteParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation {
    private ConstantPool pool;
    private int typeIndex;
    private Map<Integer, ElementValue> elementValues;

    public Annotation(ByteParser parser, ConstantPool pool) {
        this.pool = pool;
        this.typeIndex = parser.getShortAsInt();
        int elementValuePairs = parser.getShortAsInt();
        this.elementValues = new HashMap<Integer, ElementValue>(elementValuePairs);
        for (int j = 0; j < elementValuePairs; ++j) {
            int elementNameIndex = parser.getShortAsInt();
            ElementValue ev = this.parseElementValue(parser);
            this.elementValues.put(elementNameIndex, ev);
        }
    }

    private ElementValue parseElementValue(ByteParser parser) {
        ElementValue elementValue = null;
        int tag = parser.getByteAsInt();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                int constValueIndex = parser.getShortAsInt();
                elementValue = new ConstantValue(tag, constValueIndex, this.pool);
                break;
            }
            case 101: {
                int typeNameIndex = parser.getShortAsInt();
                int constNameIndex = parser.getShortAsInt();
                elementValue = new EnumValue(typeNameIndex, constNameIndex, this.pool);
                break;
            }
            case 99: {
                int classInfoIndex = parser.getShortAsInt();
                elementValue = new ClassInfoValue(classInfoIndex, this.pool);
                break;
            }
            case 64: {
                elementValue = new NestedAnnotationValue(new Annotation(parser, this.pool));
                break;
            }
            case 91: {
                int numValues = parser.getShortAsInt();
                ArrayList<ElementValue> array = new ArrayList<ElementValue>(numValues);
                for (int i = 0; i < numValues; ++i) {
                    array.add(this.parseElementValue(parser));
                }
                elementValue = new ArrayValue(array);
                break;
            }
            default: {
                throw new RuntimeException("Invalid annotation tag: " + tag + " / " + (char)tag);
            }
        }
        return elementValue;
    }

    public String getName() {
        UTF8Info info = (UTF8Info)this.pool.get(this.typeIndex);
        Descriptor desc = new Descriptor(info.getValue());
        return desc.getReturn().toString();
    }

    public int getElementValueCount() {
        return this.elementValues.size();
    }

    public Map<String, ElementValue> getElementValues() {
        HashMap<String, ElementValue> result = new HashMap<String, ElementValue>();
        for (Map.Entry<Integer, ElementValue> entry : this.elementValues.entrySet()) {
            int key = entry.getKey();
            ConstantPoolInfo nameInfo = this.pool.get(key);
            String name = nameInfo.getValue();
            result.put(name, entry.getValue());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, ElementValue> entry : this.elementValues.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            int key = entry.getKey();
            ConstantPoolInfo nameInfo = this.pool.get(key);
            String name = nameInfo.getValue();
            ElementValue ev = entry.getValue();
            sb.append(name + " = " + ev.getValue());
        }
        String pairs = sb.toString();
        sb = new StringBuilder();
        UTF8Info info = (UTF8Info)this.pool.get(this.typeIndex);
        Descriptor desc = new Descriptor(info.getValue());
        sb.append(desc.getReturn());
        if (pairs.length() > 0) {
            sb.append("(");
            sb.append(pairs);
            sb.append(")");
        }
        return sb.toString();
    }
}

