/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.attribute.annotations.Annotation;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.util.ByteArrayByteParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeInvisibleAnnotationsAttribute
extends Attribute {
    private List<Annotation> annotations = new ArrayList<Annotation>();

    public RuntimeInvisibleAnnotationsAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    @Override
    public void setPayload(byte[] data) {
        super.setPayload(data);
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        int numAnnotations = parser.getShortAsInt();
        for (int i = 0; i < numAnnotations; ++i) {
            this.annotations.add(new Annotation(parser, this.pool));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Annotation annotation : this.annotations) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(annotation.toString());
        }
        sb.insert(0, "RuntimeInvisibleAnnotations: ");
        return sb.toString();
    }

    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> list = new ArrayList<Annotation>(this.annotations.size());
        list.addAll(this.annotations);
        return list;
    }
}

