/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.attribute.generics.LocalVariableTypeEntry;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.util.ByteArrayByteParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableTypeTableAttribute
extends Attribute {
    private List<LocalVariableTypeEntry> entries = null;

    public LocalVariableTypeTableAttribute(int nameIndex, ConstantPool pool) {
        super(nameIndex, pool);
    }

    @Override
    public void setPayload(byte[] data) {
        super.setPayload(data);
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        int count = parser.getShortAsInt();
        this.entries = new ArrayList<LocalVariableTypeEntry>(count);
        for (int i = 0; i < count; ++i) {
            int startPc = parser.getShortAsInt();
            int length = parser.getShortAsInt();
            int nameIndex = parser.getShortAsInt();
            int signatureIndex = parser.getShortAsInt();
            int index = parser.getShortAsInt();
            LocalVariableTypeEntry entry = new LocalVariableTypeEntry(this.pool, startPc, length, nameIndex, signatureIndex, index);
            this.entries.add(entry);
        }
    }

    @Override
    public byte[] getPayload() {
        return super.getPayload();
    }

    @Override
    public String toString() {
        return "LocalVariableTypeTable (" + this.entries.size() + " entries)";
    }

    public List<LocalVariableTypeEntry> getEntries() {
        ArrayList<LocalVariableTypeEntry> retList = new ArrayList<LocalVariableTypeEntry>(this.entries.size());
        retList.addAll(this.entries);
        return retList;
    }
}

