/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java.attribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.rej.java.attribute.Attribute;
import net.sf.rej.java.attribute.CodeAttribute;
import net.sf.rej.java.attribute.ConstantValueAttribute;
import net.sf.rej.java.attribute.DeprecatedAttribute;
import net.sf.rej.java.attribute.ExceptionsAttribute;
import net.sf.rej.java.attribute.LineNumberTableAttribute;
import net.sf.rej.java.attribute.LocalVariableTableAttribute;
import net.sf.rej.java.attribute.LocalVariableTypeTableAttribute;
import net.sf.rej.java.attribute.RuntimeInvisibleAnnotationsAttribute;
import net.sf.rej.java.attribute.RuntimeVisibleAnnotationsAttribute;
import net.sf.rej.java.attribute.SignatureAttribute;
import net.sf.rej.java.attribute.SourceFileAttribute;
import net.sf.rej.java.attribute.SyntheticAttribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes {
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public Attributes() {
    }

    public Attributes(ByteParser parser, ConstantPool pool) {
        int count = parser.getShortAsInt();
        for (int i = 0; i < count; ++i) {
            Attribute a = Attribute.getAttribute(parser, pool);
            this.attributes.add(a);
        }
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.addAll(this.attributes);
        return attrs;
    }

    public LineNumberTableAttribute getLineNumberTable() {
        return (LineNumberTableAttribute)this.getNamedAttribute("LineNumberTable");
    }

    public LocalVariableTableAttribute getLocalVariableTable() {
        return (LocalVariableTableAttribute)this.getNamedAttribute("LocalVariableTable");
    }

    public SyntheticAttribute getSyntheticAttribute() {
        return (SyntheticAttribute)this.getNamedAttribute("Synthetic");
    }

    public DeprecatedAttribute getDeprecatedAttribute() {
        return (DeprecatedAttribute)this.getNamedAttribute("Deprecated");
    }

    public SourceFileAttribute getSourceFileAttribute() {
        return (SourceFileAttribute)this.getNamedAttribute("SourceFile");
    }

    public ExceptionsAttribute getExceptionsAttribute() {
        return (ExceptionsAttribute)this.getNamedAttribute("Exceptions");
    }

    public SignatureAttribute getSignatureAttribute() {
        return (SignatureAttribute)this.getNamedAttribute("Signature");
    }

    public LocalVariableTypeTableAttribute getLocalVariableTypeTable() {
        return (LocalVariableTypeTableAttribute)this.getNamedAttribute("LocalVariableTypeTable");
    }

    public RuntimeVisibleAnnotationsAttribute getRuntimeVisibleAnnotationsAttribute() {
        return (RuntimeVisibleAnnotationsAttribute)this.getNamedAttribute("RuntimeVisibleAnnotations");
    }

    public RuntimeInvisibleAnnotationsAttribute getRuntimeInvisibleAnnotationsAttribute() {
        return (RuntimeInvisibleAnnotationsAttribute)this.getNamedAttribute("RuntimeInvisibleAnnotations");
    }

    public CodeAttribute getCode() {
        return (CodeAttribute)this.getNamedAttribute("Code");
    }

    public ConstantValueAttribute getConstantValueAttribute() {
        return (ConstantValueAttribute)this.getNamedAttribute("ConstantValue");
    }

    public Attribute getNamedAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attr = this.attributes.get(i);
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.attributes.size());
        for (Attribute attr : this.attributes) {
            ser.addBytes(attr.getData());
        }
        return ser.getBytes();
    }

    public Map<Object, Range> getOffsetMap(int initialOffset) {
        HashMap<Object, Range> map = new HashMap<Object, Range>();
        int offset = initialOffset;
        offset += 2;
        for (Attribute attr : this.attributes) {
            int size = attr.getData().length;
            map.put(attr, new Range(offset, size));
            offset += size;
        }
        return map;
    }

    public void removeAttribute(Attribute attr) {
        this.attributes.remove(attr);
    }

    public void addAttribute(Attribute attr) {
        this.attributes.add(attr);
    }
}

