/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.DescriptorEnabled;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariable
implements DescriptorEnabled {
    private Label startLabel;
    private Label endLabel;
    private int nameIndex;
    private int descriptorIndex;
    private int index;
    private ConstantPool pool;

    public LocalVariable(ByteParser parser, ConstantPool pool) {
        this.pool = pool;
        int startPc = parser.getShortAsInt();
        int length = parser.getShortAsInt();
        this.nameIndex = parser.getShortAsInt();
        this.descriptorIndex = parser.getShortAsInt();
        this.index = parser.getShortAsInt();
        this.startLabel = new Label(startPc, this.getName() + "_start");
        this.endLabel = new Label(startPc + length, this.getName() + "_end");
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.getStartPc());
        ser.addShort(this.getEndPc() - this.getStartPc());
        ser.addShort(this.nameIndex);
        ser.addShort(this.descriptorIndex);
        ser.addShort(this.index);
        return ser.getBytes();
    }

    public String toString() {
        return this.index + " - " + this.getName();
    }

    public String getName() {
        ConstantPoolInfo cpi = this.pool.get(this.nameIndex);
        return cpi.getValue();
    }

    public boolean isInRange(int pc) {
        return pc >= this.getStartPc() && pc <= this.getEndPc();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    @Override
    public void setDescriptorIndex(int index) {
        this.descriptorIndex = index;
    }

    public Descriptor getDescriptor() {
        UTF8Info info = (UTF8Info)this.pool.get(this.descriptorIndex);
        return new Descriptor(info.getValue());
    }

    public int getStartPc() {
        return this.startLabel.getPosition();
    }

    public int getEndPc() {
        return this.endLabel.getPosition();
    }

    public List<Label> getLabels() {
        ArrayList<Label> al = new ArrayList<Label>();
        al.add(this.startLabel);
        al.add(this.endLabel);
        return al;
    }

    public String getSignatureLine() {
        return this.getDescriptor().getReturn() + " " + this.getName();
    }
}

