/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import junit.framework.TestCase;
import net.sf.rej.java.JavaType;
import org.junit.Assert;
import org.junit.Test;

public class JavaTypeTest
extends TestCase {
    @Test
    public final void testJavaTypeString() {
        JavaType jt = new JavaType("int");
        Assert.assertEquals((Object)"int", (Object)jt.getType());
        Assert.assertEquals((Object)0, (Object)jt.getDimensionCount());
        jt = new JavaType("short[]");
        Assert.assertEquals((Object)"short", (Object)jt.getType());
        Assert.assertEquals((Object)1, (Object)jt.getDimensionCount());
        jt = new JavaType("java.util.List[][]");
        Assert.assertEquals((Object)"java.util.List", (Object)jt.getType());
        Assert.assertEquals((Object)2, (Object)jt.getDimensionCount());
    }

    @Test
    public final void testJavaTypeStringInt() {
        JavaType jt = new JavaType("int", 0);
        Assert.assertEquals((Object)"int", (Object)jt.getType());
        Assert.assertEquals((Object)0, (Object)jt.getDimensionCount());
        jt = new JavaType("short", 1);
        Assert.assertEquals((Object)"short", (Object)jt.getType());
        Assert.assertEquals((Object)1, (Object)jt.getDimensionCount());
        jt = new JavaType("java.util.List", 2);
        Assert.assertEquals((Object)"java.util.List", (Object)jt.getType());
        Assert.assertEquals((Object)2, (Object)jt.getDimensionCount());
    }

    @Test
    public final void testGetType() {
        JavaType jt = new JavaType("java.util.List", 0);
        Assert.assertEquals((Object)"java.util.List", (Object)jt.getType());
        jt = new JavaType("foo.bar");
        Assert.assertEquals((Object)"foo.bar", (Object)jt.getType());
    }

    @Test
    public final void testGetDimensions() {
        JavaType jt = new JavaType("java.util.List", 0);
        Assert.assertEquals((Object)"", (Object)jt.getDimensions());
        jt = new JavaType("java.util.List", 1);
        Assert.assertEquals((Object)"[]", (Object)jt.getDimensions());
        jt = new JavaType("foo.bar[][]");
        Assert.assertEquals((Object)"[][]", (Object)jt.getDimensions());
    }

    @Test
    public final void testIsPrimitive() {
        JavaType jt = new JavaType("java.util.List", 1);
        Assert.assertFalse((boolean)jt.isPrimitive());
        jt = new JavaType("int", 0);
        Assert.assertTrue((boolean)jt.isPrimitive());
        jt = new JavaType("byte");
        Assert.assertTrue((boolean)jt.isPrimitive());
        jt = new JavaType("short");
        Assert.assertTrue((boolean)jt.isPrimitive());
        jt = new JavaType("char");
        Assert.assertTrue((boolean)jt.isPrimitive());
        jt = new JavaType("long");
        Assert.assertTrue((boolean)jt.isPrimitive());
        jt = new JavaType("float");
        Assert.assertTrue((boolean)jt.isPrimitive());
        jt = new JavaType("double");
        Assert.assertTrue((boolean)jt.isPrimitive());
        jt = new JavaType("boolean");
        Assert.assertTrue((boolean)jt.isPrimitive());
    }

    @Test
    public final void testToString() {
        JavaType jt = new JavaType("boolean");
        Assert.assertEquals((Object)"boolean", (Object)jt.toString());
        jt = new JavaType("java.lang.String");
        Assert.assertEquals((Object)"java.lang.String", (Object)jt.toString());
        jt = new JavaType("java.lang.String", 2);
        Assert.assertEquals((Object)"java.lang.String[][]", (Object)jt.toString());
    }

    @Test
    public final void testGetDimensionCount() {
        JavaType jt = new JavaType("boolean");
        Assert.assertEquals((Object)0, (Object)jt.getDimensionCount());
        jt = new JavaType("java.lang.String");
        Assert.assertEquals((Object)"java.lang.String", (Object)jt.toString());
        jt = new JavaType("java.lang.String", 2);
        Assert.assertEquals((Object)"java.lang.String[][]", (Object)jt.toString());
    }

    @Test
    public final void testGetRaw() {
        JavaType jt = new JavaType("boolean");
        Assert.assertEquals((Object)"Z", (Object)jt.getRaw());
        jt = new JavaType("int");
        Assert.assertEquals((Object)"I", (Object)jt.getRaw());
        jt = new JavaType("long");
        Assert.assertEquals((Object)"J", (Object)jt.getRaw());
        jt = new JavaType("java.lang.String");
        Assert.assertEquals((Object)"Ljava/lang/String;", (Object)jt.getRaw());
        jt = new JavaType("char[][]");
        Assert.assertEquals((Object)"[[C", (Object)jt.getRaw());
        jt = new JavaType("java.util.List", 1);
        Assert.assertEquals((Object)"[Ljava/util/List;", (Object)jt.getRaw());
    }

    @Test
    public final void testEqualsObject() {
        JavaType jt1 = new JavaType("java.util.List", 1);
        JavaType jt2 = new JavaType("java.util.List[]");
        Assert.assertTrue((boolean)jt1.equals(jt2));
        Assert.assertTrue((boolean)jt2.equals(jt1));
        Assert.assertTrue((jt1.hashCode() == jt2.hashCode() ? 1 : 0) != 0);
        jt1 = new JavaType("long", 2);
        jt2 = new JavaType("long[][]");
        Assert.assertTrue((boolean)jt1.equals(jt2));
        Assert.assertTrue((boolean)jt2.equals(jt1));
        Assert.assertTrue((jt1.hashCode() == jt2.hashCode() ? 1 : 0) != 0);
        jt1 = new JavaType("double", 2);
        jt2 = new JavaType("double");
        Assert.assertFalse((boolean)jt1.equals(jt2));
        Assert.assertFalse((boolean)jt2.equals(jt1));
        jt1 = new JavaType("java.lang.String");
        jt2 = new JavaType("java.lang.Integer");
        Assert.assertFalse((boolean)jt1.equals(jt2));
        Assert.assertFalse((boolean)jt2.equals(jt1));
    }

    @Test
    public final void testDropDimension() {
        JavaType jt = new JavaType("boolean", 2);
        Assert.assertEquals((Object)2, (Object)jt.getDimensionCount());
        jt.dropDimension();
        Assert.assertEquals((Object)1, (Object)jt.getDimensionCount());
        jt.dropDimension();
        Assert.assertEquals((Object)0, (Object)jt.getDimensionCount());
    }
}

