/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

public class JavaType {
    public static final JavaType INT = new ImmutableJavaType("int", 0);
    public static final JavaType JAVA_LANG_OBJECT = new ImmutableJavaType("java.lang.Object", 0);
    private String type;
    private int dimensions = 0;

    public JavaType(String def) {
        int i = def.indexOf("[");
        if (i == -1) {
            this.type = def;
            this.dimensions = 0;
        } else {
            this.type = def.substring(0, i);
            this.dimensions = def.substring(i).length() / 2;
        }
    }

    public JavaType(String typeName, int dimensions) {
        this.type = typeName;
        this.dimensions = dimensions;
    }

    public String getType() {
        return this.type;
    }

    public String getDimensions() {
        StringBuffer sb = new StringBuffer(this.dimensions * 2);
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public boolean isPrimitive() {
        if (this.type.equals("void")) {
            return true;
        }
        if (this.type.equals("byte")) {
            return true;
        }
        if (this.type.equals("char")) {
            return true;
        }
        if (this.type.equals("double")) {
            return true;
        }
        if (this.type.equals("float")) {
            return true;
        }
        if (this.type.equals("int")) {
            return true;
        }
        if (this.type.equals("long")) {
            return true;
        }
        if (this.type.equals("short")) {
            return true;
        }
        return this.type.equals("boolean");
    }

    public String toString() {
        return this.type + this.getDimensions();
    }

    public int getDimensionCount() {
        return this.dimensions;
    }

    public String getRaw() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append("[");
        }
        if (this.type.equals("void")) {
            sb.append("V");
        } else if (this.type.equals("byte")) {
            sb.append("B");
        } else if (this.type.equals("char")) {
            sb.append("C");
        } else if (this.type.equals("double")) {
            sb.append("D");
        } else if (this.type.equals("float")) {
            sb.append("F");
        } else if (this.type.equals("int")) {
            sb.append("I");
        } else if (this.type.equals("long")) {
            sb.append("J");
        } else if (this.type.equals("short")) {
            sb.append("S");
        } else if (this.type.equals("boolean")) {
            sb.append("Z");
        } else {
            sb.append("L" + this.type.replace('.', '/') + ";");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaType) {
            JavaType other = (JavaType)obj;
            return other.type.equals(this.type) && other.dimensions == this.dimensions;
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() + this.dimensions * 63;
    }

    public void dropDimension() {
        --this.dimensions;
    }

    public static final class ImmutableJavaType
    extends JavaType {
        public ImmutableJavaType(String typeName, int dimensions) {
            super(typeName, dimensions);
        }

        public void dropDimension() {
            throw new RuntimeException("This instance is immutable.");
        }
    }
}

