/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import net.sf.rej.java.InstructionSet;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.DoubleInfo;
import net.sf.rej.java.constantpool.FloatInfo;
import net.sf.rej.java.constantpool.IntegerInfo;
import net.sf.rej.java.constantpool.LongInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.java.constantpool.StringInfo;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.java.instruction.Parameters;

public class InstructionCopier {
    public Instruction copyInstruction(Instruction inst, ConstantPool sourcePool, ConstantPool destinationPool) {
        Instruction copy = InstructionSet.getInstance().getInstruction(inst.getOpcode());
        Parameters params = inst.getParameters();
        Parameters copyParams = new Parameters();
        block17: for (int i = 0; i < params.getCount(); ++i) {
            copyParams.addParam(params.getType(i));
            switch (params.getType(i)) {
                case TYPE_ARRAYTYPE: {
                    copyParams.addValue(params.getObject(i));
                    continue block17;
                }
                case TYPE_LOCAL_VARIABLE: 
                case TYPE_LOCAL_VARIABLE_READONLY: 
                case TYPE_LOCAL_VARIABLE_WIDE: {
                    copyParams.addValue(params.getObject(i));
                    continue block17;
                }
                case TYPE_CONSTANT_WIDE: 
                case TYPE_CONSTANT_READONLY: 
                case TYPE_CONSTANT: {
                    copyParams.addValue(params.getObject(i));
                    continue block17;
                }
                case TYPE_CONSTANT_POOL_CLASS: {
                    ClassInfo ci = (ClassInfo)sourcePool.get(params.getInt(i));
                    int index = destinationPool.optionalAddClassRef(ci.getName());
                    copyParams.addValue(index);
                    continue block17;
                }
                case TYPE_CONSTANT_POOL_CONSTANT: {
                    ConstantPoolInfo cpi = sourcePool.get(params.getInt(i));
                    switch (cpi.getType()) {
                        case 6: {
                            DoubleInfo di = (DoubleInfo)cpi;
                            DoubleInfo diCopy = new DoubleInfo(di.getHighBytes(), di.getLowBytes(), destinationPool);
                            int index = destinationPool.optionalAdd(diCopy);
                            copyParams.addValue(index);
                            continue block17;
                        }
                        case 4: {
                            FloatInfo fi = (FloatInfo)cpi;
                            FloatInfo fiCopy = new FloatInfo(fi.getBytes(), destinationPool);
                            int index = destinationPool.optionalAdd(fiCopy);
                            copyParams.addValue(index);
                            continue block17;
                        }
                        case 3: {
                            IntegerInfo ii = (IntegerInfo)cpi;
                            IntegerInfo iiCopy = new IntegerInfo(ii.getIntValue(), destinationPool);
                            int index = destinationPool.optionalAdd(iiCopy);
                            copyParams.addValue(index);
                            continue block17;
                        }
                        case 5: {
                            LongInfo li = (LongInfo)cpi;
                            LongInfo liCopy = new LongInfo(li.getLongValue(), destinationPool);
                            int index = destinationPool.optionalAdd(liCopy);
                            copyParams.addValue(index);
                            continue block17;
                        }
                        case 8: {
                            StringInfo si = (StringInfo)cpi;
                            int index = destinationPool.optionalAddString(si.getString());
                            copyParams.addValue(index);
                            continue block17;
                        }
                    }
                    continue block17;
                }
                case TYPE_CONSTANT_POOL_FIELD_REF: {
                    RefInfo ri = (RefInfo)sourcePool.get(params.getInt(i));
                    int index = destinationPool.optionalAddFieldRef(ri.getClassName(), ri.getTargetName(), ri.getMethodType());
                    copyParams.addValue(index);
                    continue block17;
                }
                case TYPE_CONSTANT_POOL_METHOD_REF: {
                    RefInfo ri = (RefInfo)sourcePool.get(params.getInt(i));
                    int index = destinationPool.optionalAddMethodRef(ri.getClassName(), ri.getTargetName(), ri.getMethodType());
                    copyParams.addValue(index);
                    continue block17;
                }
                case TYPE_LABEL: {
                    Label label = (Label)params.getObject(i);
                    copyParams.addValue(new Label(label.getPosition()));
                    continue block17;
                }
            }
        }
        copy.setParameters(copyParams);
        return copy;
    }
}

