/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import java.util.HashMap;
import java.util.Map;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.JavaType;
import net.sf.rej.java.attribute.Attributes;
import net.sf.rej.java.attribute.ConstantValueAttribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.DescriptorEnabled;
import net.sf.rej.java.constantpool.UTF8Info;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteSerializer;
import net.sf.rej.util.ByteToolkit;
import net.sf.rej.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
implements DescriptorEnabled {
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    private ConstantPool pool;
    private Attributes attributes;

    protected Field(ConstantPool pool) {
        this.pool = pool;
        this.attributes = new Attributes();
    }

    protected Field(ByteParser parser, ConstantPool pool) {
        this.pool = pool;
        this.accessFlags = parser.getShortAsInt();
        this.nameIndex = parser.getShortAsInt();
        this.descriptorIndex = parser.getShortAsInt();
        this.attributes = new Attributes(parser, this.pool);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "Field: nameIndex " + this.nameIndex + "(" + this.pool.get(this.nameIndex) + ") desriptor index " + this.descriptorIndex + "(" + this.pool.get(this.descriptorIndex) + ") accessflags 0x" + ByteToolkit.getHexString(this.accessFlags, 4);
    }

    public String getName() {
        UTF8Info info = (UTF8Info)this.pool.get(this.nameIndex);
        return info.getValue();
    }

    public Descriptor getDescriptor() {
        UTF8Info info = (UTF8Info)this.pool.get(this.descriptorIndex);
        return new Descriptor(info.getValue());
    }

    public String getSignatureLine() {
        return this.getSignatureLine(null);
    }

    public String getSignatureLine(String className) {
        StringBuffer sb = new StringBuffer();
        JavaType ret = this.getDescriptor().getReturn();
        if (ret.isPrimitive()) {
            sb.append(ret);
        } else {
            sb.append(ret.getType());
            sb.append(ret.getDimensions());
        }
        sb.append(" ");
        if (className != null) {
            sb.append(className);
            sb.append(".");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public String getAccessString() {
        StringBuffer sb = new StringBuffer();
        if (AccessFlags.isPublic(this.accessFlags)) {
            sb.append("public ");
        }
        if (AccessFlags.isPrivate(this.accessFlags)) {
            sb.append("private ");
        }
        if (AccessFlags.isProtected(this.accessFlags)) {
            sb.append("protected ");
        }
        if (AccessFlags.isAbstract(this.accessFlags)) {
            sb.append("abstract ");
        }
        if (AccessFlags.isStatic(this.accessFlags)) {
            sb.append("static ");
        }
        if (AccessFlags.isSynchronized(this.accessFlags)) {
            sb.append("synchronized ");
        }
        if (AccessFlags.isFinal(this.accessFlags)) {
            sb.append("final ");
        }
        if (AccessFlags.isNative(this.accessFlags)) {
            sb.append("native ");
        }
        return sb.toString().trim();
    }

    public void setAccessFlags(AccessFlags accessFlags) {
        this.accessFlags = accessFlags.getValue();
    }

    @Override
    public void setDescriptorIndex(int descriptorIndex) {
        this.descriptorIndex = descriptorIndex;
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public ConstantPoolInfo getConstant() {
        ConstantValueAttribute attr = this.attributes.getConstantValueAttribute();
        if (attr != null) {
            int index = attr.getConstantIndex();
            ConstantPoolInfo cpi = this.pool.get(index);
            return cpi;
        }
        return null;
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.accessFlags);
        ser.addShort(this.nameIndex);
        ser.addShort(this.descriptorIndex);
        ser.addBytes(this.attributes.getData());
        return ser.getBytes();
    }

    public Map<Object, Range> getOffsetMap() {
        HashMap<Object, Range> map = new HashMap<Object, Range>();
        int offset = 0;
        map.put((Object)OffsetTag.ACCESS_FLAGS, new Range(offset, 2));
        map.put((Object)OffsetTag.FIELD_NAME, new Range(offset += 2, 2));
        map.put((Object)OffsetTag.FIELD_DESCRIPTOR, new Range(offset += 2, 2));
        map.put((Object)OffsetTag.ATTRIBUTES, new Range(offset += 2, this.attributes.getData().length));
        map.putAll(this.attributes.getOffsetMap(offset));
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OffsetTag {
        ACCESS_FLAGS,
        FIELD_NAME,
        FIELD_DESCRIPTOR,
        ATTRIBUTES;

    }
}

